/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.opensearch;

import javax.xml.namespace.QName;
import org.apache.abdera.Abdera;
import org.apache.abdera.ext.opensearch.OpenSearchConstants;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ElementWrapper;
import org.apache.abdera.model.ExtensibleElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query
extends ElementWrapper {
    public Query(Element internal) {
        super(internal);
    }

    public Query(Factory factory) {
        super(factory, OpenSearchConstants.QUERY);
    }

    public Query(Abdera abdera) {
        this(abdera.getFactory());
    }

    public Query(ExtensibleElement parent) {
        this(parent.getFactory());
        parent.declareNS("http://a9.com/-/spec/opensearch/1.1/", "os");
    }

    public Role getRole() {
        String role = this.getInternal().getAttributeValue("role");
        if (role == null) {
            return null;
        }
        try {
            return Role.valueOf(role.toUpperCase());
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setRole(Role role) {
        if (role != null) {
            this.getInternal().setAttributeValue("role", role.name().toLowerCase());
        } else {
            this.getInternal().removeAttribute(new QName("role"));
        }
    }

    public String getTitle() {
        return this.getInternal().getAttributeValue("title");
    }

    public void setTitle(String title) {
        if (title != null) {
            if (title.length() > 256) {
                throw new IllegalArgumentException("Title too long (max 256 characters)");
            }
            this.getInternal().setAttributeValue("title", title);
        } else {
            this.getInternal().removeAttribute(new QName("title"));
        }
    }

    public int getTotalResults() {
        String val = this.getInternal().getAttributeValue("totalResults");
        return val != null ? Integer.parseInt(val) : -1;
    }

    public void setTotalResults(int totalResults) {
        if (totalResults > -1) {
            this.getInternal().setAttributeValue("totalResults", String.valueOf(totalResults));
        } else {
            this.getInternal().removeAttribute(new QName("totalResults"));
        }
    }

    public String getSearchTerms() {
        return this.getInternal().getAttributeValue("searchTerms");
    }

    public void setSearchTerms(String terms) {
        if (terms != null) {
            this.getInternal().setAttributeValue("searchTerms", terms);
        } else {
            this.getInternal().removeAttribute(new QName("searchTerms"));
        }
    }

    public int getCount() {
        String val = this.getInternal().getAttributeValue("count");
        return val != null ? Integer.parseInt(val) : -1;
    }

    public void setCount(int count) {
        if (count > -1) {
            this.getInternal().setAttributeValue("count", String.valueOf(count));
        } else {
            this.getInternal().removeAttribute(new QName("count"));
        }
    }

    public int getStartIndex() {
        String val = this.getInternal().getAttributeValue("startIndex");
        return val != null ? Integer.parseInt(val) : -1;
    }

    public void setStartIndex(int startIndex) {
        if (startIndex > -1) {
            this.getInternal().setAttributeValue("startIndex", String.valueOf(startIndex));
        } else {
            this.getInternal().removeAttribute(new QName("startIndex"));
        }
    }

    public int getStartPage() {
        String val = this.getInternal().getAttributeValue("startPage");
        return val != null ? Integer.parseInt(val) : -1;
    }

    public void setStartPage(int startPage) {
        if (startPage > -1) {
            this.getInternal().setAttributeValue("startPage", String.valueOf(startPage));
        } else {
            this.getInternal().removeAttribute(new QName("startPage"));
        }
    }

    public String getLanguage() {
        return this.getInternal().getAttributeValue("language");
    }

    public <T extends Element> T setLanguage(String language) {
        if (language != null) {
            this.getInternal().setAttributeValue("language", language);
        } else {
            this.getInternal().removeAttribute(new QName("language"));
        }
        return (T)((Object)this);
    }

    public String getInputEncoding() {
        return this.getInternal().getAttributeValue("inputEncoding");
    }

    public void setInputEncoding(String encoding) {
        if (encoding != null) {
            this.getInternal().setAttributeValue("inputEncoding", encoding);
        } else {
            this.getInternal().removeAttribute(new QName("inputEncoding"));
        }
    }

    public String getOutputEncoding() {
        return this.getInternal().getAttributeValue("outputEncoding");
    }

    public void setOutputEncoding(String encoding) {
        if (encoding != null) {
            this.getInternal().setAttributeValue("outputEncoding", encoding);
        } else {
            this.getInternal().removeAttribute(new QName("outputEncoding"));
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + (this.getInternal() == null ? 0 : this.getInternal().hashCode());
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Role {
        CORRECTION,
        EXAMPLE,
        RELATED,
        REQUEST,
        SUBSET,
        SUPERSET;

    }
}

