/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.examples.uritemplates;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.abdera.i18n.templates.CachingContext;
import org.apache.abdera.i18n.templates.Context;
import org.apache.abdera.i18n.templates.HashMapContext;
import org.apache.abdera.i18n.templates.Template;

public final class URITemplates {
    private static final Template template = new Template("http://example.org{-opt|/~|user}{user}{-opt|/-/|categories}{-listjoin|/|categories}{-opt|?|foo,bar}{-join|&|foo,bar}");

    public static void main(String ... args) throws Exception {
        URITemplates.exampleWithObject();
        URITemplates.exampleIRIWithObject();
        URITemplates.exampleWithMap();
        URITemplates.exampleWithHashMapContext();
        URITemplates.exampleWithCustomContext();
        System.out.println(template);
    }

    private static void exampleWithObject() {
        MyObject myObject = new MyObject();
        System.out.println(template.expand((Object)myObject));
    }

    private static void exampleIRIWithObject() {
        MyObject myObject = new MyObject();
        System.out.println(template.expand((Object)myObject, true));
    }

    private static void exampleWithMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("user", "james");
        map.put("categories", new String[]{"a", "b", "c"});
        map.put("foo", "abc");
        map.put("bar", "xyz");
        System.out.println(template.expand(map));
    }

    private static void exampleWithHashMapContext() {
        HashMapContext context = new HashMapContext();
        context.put((Object)"user", (Object)"james");
        context.put((Object)"categories", (Object)new String[]{"a", "b", "c"});
        context.put((Object)"foo", (Object)"abc");
        context.put((Object)"bar", (Object)"xyz");
        System.out.println(template.expand((Context)context));
    }

    private static void exampleWithCustomContext() {
        CachingContext context = new CachingContext(){
            private static final long serialVersionUID = 4896250661828139020L;

            protected <T> T resolveActual(String var) {
                if (var.equals("user")) {
                    return (T)"james";
                }
                if (var.equals("categories")) {
                    return (T)new String[]{"a", "b", "c"};
                }
                if (var.equals("foo")) {
                    return (T)"abc";
                }
                if (var.equals("bar")) {
                    return (T)"xyz";
                }
                return null;
            }

            public Iterator<String> iterator() {
                return Arrays.asList("user", "categories", "foo", "bar").iterator();
            }
        };
        System.out.println(template.expand((Context)context));
    }

    private static class Foo {
        private Foo() {
        }

        public String toString() {
            return "abc\u00e6";
        }
    }

    public static class MyObject {
        public String user = "james";

        public List getCategories() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("a");
            list.add("b");
            list.add("c");
            return list;
        }

        public Foo[] getFoo() {
            return new Foo[]{new Foo(), new Foo()};
        }

        public String getBar() {
            return "xyz";
        }
    }
}

