/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.examples.simple;

import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;

public class Create {
    public static void main(String[] args) throws Exception {
        Factory factory = Abdera.getNewFactory();
        Feed feed = factory.newFeed();
        feed.setLanguage("en-US");
        feed.setBaseUri("http://example.org");
        feed.setTitle("Example Feed");
        feed.addLink("http://example.org/");
        feed.setUpdated(new Date());
        feed.addAuthor("John Doe");
        feed.setId("urn:uuid:60a76c80-d399-11d9-b93C-0003939e0af6");
        feed.addContributor("Bob Jones");
        feed.addCategory("example");
        Entry entry = feed.insertEntry();
        entry.setTitle("Atom-Powered Robots Run Amok");
        entry.addLink("http://example.org/2003/12/13/atom03");
        entry.setId("urn:uuid:1225c695-cfb8-4ebb-aaaa-80da344efa6a");
        entry.setUpdated(new Date());
        entry.setSummary("Some text.");
        Entry entry2 = feed.insertEntry();
        entry2.setTitle("re: Atom-Powered Robots Run Amok");
        entry2.addLink("/2003/12/13/atom03/1");
        entry2.setId("urn:uuid:1225c695-cfb8-4ebb-aaaa-80cb323feb5b");
        entry2.setUpdated(new Date());
        entry2.setSummary("A response");
        Entry entry3 = feed.addEntry();
        entry3.setTitleAsXhtml("<p>Test</p>");
        entry3.addLink("/2003/12/13/atom03/2");
        entry3.setId("HTTP://www.Example.org/foo/../bar", true);
        entry3.setUpdated(new Date());
        entry3.setSummaryAsHtml("<p><a href=\"foo\">Test</a></p>").setBaseUri("http://example.org/site/");
        entry3.setSource(feed.getAsSource());
        Entry entry4 = feed.addEntry();
        entry4.setTitle("re: Atom-Powered Robots Run Amok");
        entry4.addLink("/2003/12/13/atom03/3");
        entry4.setId("urn:uuid:1225c695-cfb8-4ebb-aaaa-cafebabecafe");
        entry4.setUpdated(new Date());
        entry4.setSummary("An entry with out-of-line content");
        entry4.setContent(new IRI("http://example.org/0xcafebabe"), "text/html");
        Entry entry5 = feed.addEntry();
        entry5.setTitle("re: Atom-Powered Robots Run Amok");
        entry5.addLink("/2003/12/13/atom03/4");
        entry5.setId("urn:uuid:1225c695-cfb8-4ebb-aaaa-80cb323feb5c");
        entry5.setUpdated(new Date());
        entry5.setSummary("A simple Base64 encoded binary image");
        URL url = Create.class.getResource("/atom-logo75px.gif");
        entry5.setContent(new DataHandler((DataSource)new URLDataSource(url)), "image/gif");
        Entry entry6 = feed.addEntry();
        entry6.setTitle("re: Atom-Powered Robots Run Amok");
        entry6.addLink("/2003/12/13/atom03/5");
        entry6.setId("urn:uuid:1225c695-cfb8-4ebb-aaaa-80cb323feb5d");
        entry6.setUpdated(new Date());
        entry6.setSummary("XML content");
        entry6.setContent("<a xmlns='urn:foo'><b/></a>", Content.Type.XML);
        feed.getDocument().writeTo((OutputStream)System.out);
    }
}

