/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.examples.ext;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import org.apache.abdera.Abdera;
import org.apache.abdera.ext.serializer.ConventionSerializationContext;
import org.apache.abdera.ext.serializer.annotation.Author;
import org.apache.abdera.ext.serializer.annotation.ID;
import org.apache.abdera.ext.serializer.annotation.Link;
import org.apache.abdera.ext.serializer.annotation.Published;
import org.apache.abdera.ext.serializer.annotation.Summary;
import org.apache.abdera.ext.serializer.annotation.Title;
import org.apache.abdera.ext.serializer.annotation.Updated;
import org.apache.abdera.ext.serializer.impl.EntrySerializer;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.writer.StreamWriter;

public class Serializer {
    static Date date_now = new Date();
    static Calendar cal_now = Calendar.getInstance();

    public static void main(String ... args) throws Exception {
        Abdera abdera = Abdera.getInstance();
        StreamWriter sw = abdera.newStreamWriter();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        sw.setOutputStream((OutputStream)out).setAutoIndent(true);
        ConventionSerializationContext c = new ConventionSerializationContext(sw);
        c.setSerializer(MyEntry.class, (org.apache.abdera.ext.serializer.Serializer)new EntrySerializer());
        sw.startDocument();
        c.serialize((Object)new MyEntry());
        sw.endDocument();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        Document doc = abdera.getParser().parse((InputStream)in);
        Entry entry = (Entry)doc.getRoot();
        entry.writeTo((OutputStream)System.out);
        System.out.println();
        sw = abdera.newStreamWriter();
        out = new ByteArrayOutputStream();
        sw.setOutputStream((OutputStream)out).setAutoIndent(true);
        c = new ConventionSerializationContext(sw);
        sw.startDocument();
        c.serialize((Object)new MyAnnotatedEntry());
        sw.endDocument();
        in = new ByteArrayInputStream(out.toByteArray());
        doc = abdera.getParser().parse((InputStream)in);
        entry = (Entry)doc.getRoot();
        entry.writeTo((OutputStream)System.out);
    }

    @org.apache.abdera.ext.serializer.annotation.Entry
    public static class MyAnnotatedEntry {
        @ID
        public String getFoo() {
            return "tag:example.org,2008:foo";
        }

        @Title
        public String getBar() {
            return "This is the title";
        }

        @Author
        public String getBaz() {
            return "James";
        }

        @Updated
        @Published
        public Date getLastModified() {
            return date_now;
        }

        @Summary
        public String getText() {
            return "this is the summary";
        }

        @Link
        public String getUri() {
            return "http://example.org/foo";
        }
    }

    public static class MyEntry {
        public String getId() {
            return "tag:example.org,2008:foo";
        }

        public String getTitle() {
            return "This is the title";
        }

        public String getAuthor() {
            return "James";
        }

        public Date getUpdated() {
            return date_now;
        }

        public Calendar getPublished() {
            return cal_now;
        }

        public String getSummary() {
            return "this is the summary";
        }

        public String getLink() {
            return "http://example.org/foo";
        }
    }
}

