/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.examples.appserver.employee;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.abdera.Abdera;
import org.apache.abdera.examples.appserver.employee.Employee;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Person;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.apache.abdera.protocol.server.impl.AbstractEntityCollectionAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmployeeCollectionAdapter
extends AbstractEntityCollectionAdapter<Employee> {
    private static final String ID_PREFIX = "tag:acme.com,2007:employee:entry:";
    private AtomicInteger nextId = new AtomicInteger(1000);
    private Map<Integer, Employee> employees = new HashMap<Integer, Employee>();
    private Factory factory = new Abdera().getFactory();

    public String getId(RequestContext request) {
        return "tag:acme.com,2007:employee:feed";
    }

    public String getTitle(RequestContext request) {
        return "Acme Employee Database";
    }

    public String getAuthor(RequestContext request) {
        return "Acme Industries";
    }

    public Iterable<Employee> getEntries(RequestContext request) {
        return this.employees.values();
    }

    public Employee getEntry(String resourceName, RequestContext request) throws ResponseContextException {
        Integer id = this.getIdFromResourceName(resourceName);
        return this.employees.get(id);
    }

    private Integer getIdFromResourceName(String resourceName) throws ResponseContextException {
        int idx = resourceName.indexOf("-");
        if (idx == -1) {
            throw new ResponseContextException(404);
        }
        return new Integer(resourceName.substring(0, idx));
    }

    public String getName(Employee entry) {
        return entry.getId() + "-" + entry.getName().replaceAll(" ", "_");
    }

    public String getId(Employee entry) {
        return ID_PREFIX + entry.getId();
    }

    public String getTitle(Employee entry) {
        return entry.getName();
    }

    public Date getUpdated(Employee entry) {
        return entry.getUpdated();
    }

    public List<Person> getAuthors(Employee entry, RequestContext request) throws ResponseContextException {
        Person author = request.getAbdera().getFactory().newAuthor();
        author.setName("Acme Industries");
        return Arrays.asList(author);
    }

    public Object getContent(Employee entry, RequestContext request) {
        Content content = this.factory.newContent(Content.Type.TEXT);
        content.setText(entry.getName());
        return content;
    }

    public Employee postEntry(String title, IRI id, String summary, Date updated, List<Person> authors, Content content, RequestContext request) throws ResponseContextException {
        Employee employee = new Employee();
        employee.setName(content.getText().trim());
        employee.setId(this.nextId.getAndIncrement());
        this.employees.put(employee.getId(), employee);
        return employee;
    }

    public void putEntry(Employee employee, String title, Date updated, List<Person> authors, String summary, Content content, RequestContext request) throws ResponseContextException {
        employee.setName(content.getText().trim());
    }

    public void deleteEntry(String resourceName, RequestContext request) throws ResponseContextException {
        Integer id = this.getIdFromResourceName(resourceName);
        this.employees.remove(id);
    }
}

