/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.examples.appserver.employee;

import javax.servlet.Servlet;
import org.apache.abdera.examples.appserver.employee.EmployeeCollectionAdapter;
import org.apache.abdera.protocol.server.CollectionInfo;
import org.apache.abdera.protocol.server.Provider;
import org.apache.abdera.protocol.server.WorkspaceInfo;
import org.apache.abdera.protocol.server.impl.DefaultProvider;
import org.apache.abdera.protocol.server.impl.SimpleWorkspaceInfo;
import org.apache.abdera.protocol.server.servlet.AbderaServlet;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

public class AppServer {
    public static void main(String ... args) throws Exception {
        int port = 9002;
        try {
            port = args.length > 0 ? Integer.parseInt(args[0]) : 9002;
        }
        catch (Exception e) {
            // empty catch block
        }
        Server server = new Server(port);
        Context context = new Context((HandlerContainer)server, "/", 1);
        ServletHolder servletHolder = new ServletHolder((Servlet)new EmployeeProviderServlet());
        context.addServlet(servletHolder, "/*");
        server.start();
        server.join();
    }

    public static final class EmployeeProviderServlet
    extends AbderaServlet {
        protected Provider createProvider() {
            EmployeeCollectionAdapter ca = new EmployeeCollectionAdapter();
            ca.setHref("employee");
            SimpleWorkspaceInfo wi = new SimpleWorkspaceInfo();
            wi.setTitle("Employee Directory Workspace");
            wi.addCollection((CollectionInfo)ca);
            DefaultProvider provider = new DefaultProvider("/");
            provider.addWorkspace((WorkspaceInfo)wi);
            provider.init(this.getAbdera(), null);
            return provider;
        }
    }
}

