/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.util;

public class AnsiColor {
    private static final String PREFIX = "antublue.test.engine";
    private static final String MAVEN_PLUGIN_MODE = "antublue.test.engine.maven.plugin.mode";
    private static final String MAVEN_PLUGIN_BATCH = "antublue.test.engine.maven.plugin.batch";
    private static final String NO_COLOR = "NO_COLOR";
    private static final String EMPTY_STRING = "";
    private static final String ONE = "1";
    public static final AnsiColor TEXT_RESET = new AnsiColor("\u001b[0m");
    public static final AnsiColor TEXT_BLACK = new AnsiColor("\u001b[0;30m");
    public static final AnsiColor TEXT_RED = new AnsiColor("\u001b[0;38;5;160m");
    public static final AnsiColor TEXT_GREEN = new AnsiColor("\u001b[0;32m");
    public static final AnsiColor TEXT_YELLOW = new AnsiColor("\u001b[0;33m");
    public static final AnsiColor TEXT_BLUE = new AnsiColor("\u001b[0;34m");
    public static final AnsiColor TEXT_PURPLE = new AnsiColor("\u001b[0;35m");
    public static final AnsiColor TEXT_CYAN = new AnsiColor("\u001b[0;36m");
    public static final AnsiColor TEXT_WHITE = new AnsiColor("\u001b[0;37m");
    public static final AnsiColor TEXT_BLACK_BOLD = new AnsiColor("\u001b[1;30m");
    public static final AnsiColor TEXT_RED_BOLD = new AnsiColor("\u001b[1;31m");
    public static final AnsiColor TEXT_GREEN_BOLD = new AnsiColor("\u001b[1;32m");
    public static final AnsiColor TEXT_YELLOW_BOLD = new AnsiColor("\u001b[1;33m");
    public static final AnsiColor TEXT_BLUE_BOLD = new AnsiColor("\u001b[1;34m");
    public static final AnsiColor TEXT_PURPLE_BOLD = new AnsiColor("\u001b[1;35m");
    public static final AnsiColor TEXT_CYAN_BOLD = new AnsiColor("\u001b[1;36m");
    public static final AnsiColor TEXT_WHITE_BOLD = new AnsiColor("\u001b[1;37m");
    public static final AnsiColor TEXT_BLACK_UNDERLINED = new AnsiColor("\u001b[4;30m");
    public static final AnsiColor TEXT_RED_UNDERLINED = new AnsiColor("\u001b[4;31m");
    public static final AnsiColor TEXT_GREEN_UNDERLINED = new AnsiColor("\u001b[4;32m");
    public static final AnsiColor TEXT_YELLOW_UNDERLINED = new AnsiColor("\u001b[4;33m");
    public static final AnsiColor TEXT_BLUE_UNDERLINED = new AnsiColor("\u001b[4;34m");
    public static final AnsiColor TEXT_PURPLE_UNDERLINED = new AnsiColor("\u001b[4;35m");
    public static final AnsiColor TEXT_CYAN_UNDERLINED = new AnsiColor("\u001b[4;36m");
    public static final AnsiColor TEXT_WHITE_UNDERLINED = new AnsiColor("\u001b[4;37m");
    public static final AnsiColor TEXT_BLACK_BRIGHT = new AnsiColor("\u001b[0;90m");
    public static final AnsiColor TEXT_RED_BRIGHT = new AnsiColor("\u001b[0;38;5;196m");
    public static final AnsiColor TEXT_GREEN_BRIGHT = new AnsiColor("\u001b[0;92m");
    public static final AnsiColor TEXT_YELLOW_BRIGHT = new AnsiColor("\u001b[0;93m");
    public static final AnsiColor TEXT_BLUE_BRIGHT = new AnsiColor("\u001b[0;94m");
    public static final AnsiColor TEXT_PURPLE_BRIGHT = new AnsiColor("\u001b[0;95m");
    public static final AnsiColor TEXT_CYAN_BRIGHT = new AnsiColor("\u001b[0;96m");
    public static final AnsiColor TEXT_WHITE_BRIGHT = new AnsiColor("\u001b[1;97m");
    public static final AnsiColor TEXT_BLACK_BOLD_BRIGHT = new AnsiColor("\u001b[1;90m");
    public static final AnsiColor TEXT_RED_BOLD_BRIGHT = new AnsiColor("\u001b[1;38;5;160m");
    public static final AnsiColor TEXT_GREEN_BOLD_BRIGHT = new AnsiColor("\u001b[1;92m");
    public static final AnsiColor TEXT_YELLOW_BOLD_BRIGHT = new AnsiColor("\u001b[1;93m");
    public static final AnsiColor TEXT_BLUE_BOLD_BRIGHT = new AnsiColor("\u001b[1;94m");
    public static final AnsiColor TEXT_PURPLE_BOLD_BRIGHT = new AnsiColor("\u001b[1;95m");
    public static final AnsiColor TEXT_CYAN_BOLD_BRIGHT = new AnsiColor("\u001b[1;96m");
    public static final AnsiColor TEXT_WHITE_BOLD_BRIGHT = new AnsiColor("\u001b[1;97m");
    public static final AnsiColor BACKGROUND_BLACK = new AnsiColor("\u001b[40m");
    public static final AnsiColor BACKGROUND_RED = new AnsiColor("\u001b[41m");
    public static final AnsiColor BACKGROUND_GREEN = new AnsiColor("\u001b[42m");
    public static final AnsiColor BACKGROUND_YELLOW = new AnsiColor("\u001b[43m");
    public static final AnsiColor BACKGROUND_BLUE = new AnsiColor("\u001b[44m");
    public static final AnsiColor BACKGROUND_PURPLE = new AnsiColor("\u001b[45m");
    public static final AnsiColor BACKGROUND_CYAN = new AnsiColor("\u001b[46m");
    public static final AnsiColor BACKGROUND_WHITE = new AnsiColor("\u001b[47m");
    public static final AnsiColor BACKGROUND_BLACK_BRIGHT = new AnsiColor("\u001b[0;100m");
    public static final AnsiColor BACKGROUND_RED_BRIGHT = new AnsiColor("\u001b[0;101m");
    public static final AnsiColor BACKGROUND_GREEN_BRIGHT = new AnsiColor("\u001b[0;102m");
    public static final AnsiColor BACKGROUND_YELLOW_BRIGHT = new AnsiColor("\u001b[0;103m");
    public static final AnsiColor BACKGROUND_BLUE_BRIGHT = new AnsiColor("\u001b[0;104m");
    public static final AnsiColor BACKGROUND_PURPLE_BRIGHT = new AnsiColor("\u001b[0;105m");
    public static final AnsiColor BACKGROUND_CYAN_BRIGHT = new AnsiColor("\u001b[0;106m");
    public static final AnsiColor BACKGROUND_WHITE_BRIGHT = new AnsiColor("\u001b[0;107m");
    private static boolean ANSI_COLOR_SUPPORTED;
    private final String escapeSequence;

    private AnsiColor(String escapeSequence) {
        this.escapeSequence = escapeSequence;
    }

    public String wrap(Object object) {
        if (ANSI_COLOR_SUPPORTED) {
            return this.escapeSequence + object + TEXT_RESET;
        }
        return String.valueOf(object);
    }

    public String toString() {
        if (ANSI_COLOR_SUPPORTED) {
            return this.escapeSequence;
        }
        return EMPTY_STRING;
    }

    public static boolean isSupported() {
        return ANSI_COLOR_SUPPORTED;
    }

    public static void setSupported(boolean ansiColorSupported) {
        ANSI_COLOR_SUPPORTED = ansiColorSupported;
    }

    public static AnsiColor ofSequence(String escapeSequence) {
        return new AnsiColor(escapeSequence);
    }

    static {
        boolean bl = ANSI_COLOR_SUPPORTED = System.console() != null;
        if (ONE.equals(System.getenv(NO_COLOR))) {
            ANSI_COLOR_SUPPORTED = false;
        }
        if (MAVEN_PLUGIN_BATCH.equals(System.getenv(MAVEN_PLUGIN_MODE))) {
            ANSI_COLOR_SUPPORTED = false;
        }
    }
}

