/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.logger;

import java.util.HashMap;
import java.util.Map;

public final class Level {
    public static final Level ERROR = new Level(100, "ERROR");
    public static final Level WARN = new Level(200, "WARN");
    public static final Level INFO = new Level(300, "INFO");
    public static final Level DEBUG = new Level(400, "DEBUG");
    public static final Level TRACE = new Level(500, "TRACE");
    public static final Level ALL = new Level(Integer.MAX_VALUE, "ALL");
    private static final Map<String, Level> LEVEL_MAP = new HashMap<String, Level>();
    private final int level;
    private final String string;

    private Level(int level, String string) {
        this.level = level;
        this.string = string;
    }

    public int toInt() {
        return this.level;
    }

    public String toString() {
        return this.string;
    }

    public static Level toLevel(String string, Level defaultLevel) {
        return LEVEL_MAP.getOrDefault(string, defaultLevel);
    }

    static {
        LEVEL_MAP.put(ERROR.toString(), ERROR);
        LEVEL_MAP.put(WARN.toString(), WARN);
        LEVEL_MAP.put(INFO.toString(), INFO);
        LEVEL_MAP.put(DEBUG.toString(), DEBUG);
        LEVEL_MAP.put(TRACE.toString(), TRACE);
        LEVEL_MAP.put(ALL.toString(), ALL);
    }
}

