/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.util.ArrayList;
import java.util.List;
import org.antublue.test.engine.internal.metadata.Metadata;
import org.antublue.test.engine.internal.metadata.MetadataInformation;
import org.antublue.test.engine.internal.util.StopWatch;
import org.antublue.test.engine.internal.util.ThrowableCollector;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;

public abstract class ExecutableTestDescriptor
extends AbstractTestDescriptor
implements Metadata {
    private final ThrowableCollector throwableCollector = new ThrowableCollector();
    private final MetadataInformation metadataInformation = new MetadataInformation();
    private final StopWatch stopWatch = new StopWatch();

    protected ExecutableTestDescriptor(UniqueId uniqueId, String displayName) {
        super(uniqueId, displayName);
    }

    public abstract void execute(ExecutionRequest var1, Object var2);

    public abstract void skip(ExecutionRequest var1);

    @Override
    public MetadataInformation getMetadata() {
        return this.metadataInformation;
    }

    public String toString() {
        return this.getDisplayName();
    }

    protected StopWatch getStopWatch() {
        return this.stopWatch;
    }

    protected ThrowableCollector getThrowableCollector() {
        return this.throwableCollector;
    }

    public List<Throwable> collectThrowables() {
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        if (this.getThrowableCollector().isNotEmpty()) {
            throwables.addAll(this.getThrowableCollector().getThrowables());
        }
        this.getChildren().forEach(testDescriptor -> {
            ExecutableTestDescriptor executableTestDescriptor;
            List<Throwable> childThrowables;
            if (testDescriptor instanceof ExecutableTestDescriptor && (childThrowables = (executableTestDescriptor = (ExecutableTestDescriptor)testDescriptor).collectThrowables()) != null) {
                throwables.addAll(childThrowables);
            }
        });
        return throwables;
    }
}

