/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.antublue.test.engine.exception.TestEngineConfigurationException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ConfigurationParameters;

public class Configuration
implements ConfigurationParameters {
    private static final String ANTUBLUE_TEST_ENGINE_CONFIGURATION_TRACE = "ANTUBLUE_TEST_ENGINE_CONFIGURATION_TRACE";
    private static final String ANTUBLUE_TEST_ENGINE_PROPERTIES_FILENAME = "antublue-test-engine.properties";
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd | HH:mm:ss.SSS", Locale.getDefault());
    private boolean IS_TRACE_ENABLED;
    private final Map<String, String> map;

    public Configuration() {
        block11: {
            this.trace("Constructor()");
            this.map = Collections.synchronizedMap(new TreeMap());
            try {
                Optional<File> optional = Configuration.find(Paths.get(".", new String[0]), ANTUBLUE_TEST_ENGINE_PROPERTIES_FILENAME);
                if (!optional.isPresent()) break block11;
                if (this.IS_TRACE_ENABLED) {
                    this.trace("antublue.test.engine.properties [" + optional.get().getAbsolutePath() + "]");
                }
                Properties properties = new Properties();
                try (BufferedReader reader = Files.newBufferedReader(optional.get().toPath(), StandardCharsets.UTF_8);){
                    properties.load(reader);
                }
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.set(Configuration.toEnvironmentVariable((String)key), (String)value)));
                properties.put(ANTUBLUE_TEST_ENGINE_PROPERTIES_FILENAME, optional.get().getAbsolutePath());
            }
            catch (IOException e) {
                throw new TestEngineConfigurationException("Exception loading properties", e);
            }
        }
        if ("true".equals(System.getenv().get(ANTUBLUE_TEST_ENGINE_CONFIGURATION_TRACE))) {
            this.IS_TRACE_ENABLED = true;
        }
        System.getenv().forEach(this::set);
        if (this.IS_TRACE_ENABLED) {
            this.map.forEach((key, value) -> this.trace(key + " = [" + value + "]"));
        }
    }

    public void set(String key, String value) {
        Preconditions.notNull((Object)key, (String)"key is null");
        Preconditions.notNull((Object)value, (String)"value is null");
        this.map.put(Configuration.toEnvironmentVariable(key), value);
    }

    public Optional<String> get(String key) {
        Preconditions.notNull((Object)key, (String)"key is null");
        return Optional.ofNullable(this.map.get(Configuration.toEnvironmentVariable(key)));
    }

    public Optional<Boolean> getBoolean(String key) {
        Preconditions.notNull((Object)key, (String)"key is null");
        Optional<String> optional = this.get(key);
        return optional.map("true"::equals);
    }

    public <T> Optional<T> get(String key, Function<String, T> transformer) {
        Preconditions.notNull((Object)key, (String)"key is null");
        Preconditions.notNull(transformer, (String)"transformer is null");
        String value = this.map.get(Configuration.toEnvironmentVariable(key));
        if (value != null) {
            return Optional.ofNullable(transformer.apply(value));
        }
        return Optional.empty();
    }

    public int size() {
        return this.keySet().size();
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return this.map.entrySet();
    }

    public static Configuration getInstance() {
        return SingletonHolder.SINGLETON;
    }

    private static String toEnvironmentVariable(String key) {
        return key.toUpperCase(Locale.ENGLISH).replace('.', '_');
    }

    private static Optional<File> find(Path path, String filename) {
        Path currentPath = path.toAbsolutePath().normalize();
        while (true) {
            File file;
            if ((file = new File(currentPath.toAbsolutePath() + File.separator + filename)).exists() && file.isFile() && file.canRead()) {
                return Optional.of(file);
            }
            if ((currentPath = currentPath.getParent()) == null) break;
            currentPath = currentPath.toAbsolutePath().normalize();
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trace(String message) {
        if (this.IS_TRACE_ENABLED) {
            String dateTime;
            SimpleDateFormat simpleDateFormat = SIMPLE_DATE_FORMAT;
            synchronized (simpleDateFormat) {
                dateTime = SIMPLE_DATE_FORMAT.format(new Date());
            }
            System.out.println(dateTime + " | " + Thread.currentThread().getName() + " | TRACE | " + Configuration.class.getName() + " | " + message + " ");
        }
    }

    private static class SingletonHolder {
        public static final Configuration SINGLETON = new Configuration();

        private SingletonHolder() {
        }
    }
}

