/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.maven.plugin.listener;

import java.lang.reflect.Method;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.internal.configuration.Configuration;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.metadata.Metadata;
import org.antublue.test.engine.internal.metadata.MetadataInformation;
import org.antublue.test.engine.internal.util.AnsiColor;
import org.antublue.test.engine.internal.util.AnsiColorStringBuilder;
import org.antublue.test.engine.internal.util.HumanReadableTimeUtils;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;

public class StatusEngineExecutionListener
implements EngineExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusEngineExecutionListener.class);
    private static final String INFO = new AnsiColorStringBuilder().color(AnsiColor.TEXT_WHITE).append("[").color(AnsiColor.TEXT_BLUE_BOLD).append("INFO").color(AnsiColor.TEXT_WHITE).append("]").color(AnsiColor.TEXT_RESET).toString();
    private final boolean consoleLogTiming;
    private final String consoleLogTimingUnits;
    private final boolean consoleLogTestMessages;
    private final String consoleTestMessage;
    private final boolean consoleLogSkipMessages;
    private final String consoleSkipMessage;
    private final boolean consoleLogPassMessages;
    private final String consolePassMessage;
    private final String consoleFailMessage;

    public StatusEngineExecutionListener() {
        Configuration configuration = Configuration.getInstance();
        this.consoleLogTiming = configuration.getBoolean("antublue.test.engine.console.log.timing").orElse(true);
        LOGGER.trace("configuration [%s] = [%b]", new Object[]{"antublue.test.engine.console.log.timing", this.consoleLogTiming});
        this.consoleLogTimingUnits = configuration.get("antublue.test.engine.console.log.timing.units").orElse("milliseconds");
        LOGGER.trace("configuration [%s] = [%s]", new Object[]{"antublue.test.engine.console.log.timing.units", this.consoleLogTimingUnits});
        this.consoleLogTestMessages = configuration.getBoolean("antublue.test.engine.console.log.test.messages").orElse(true);
        LOGGER.trace("configuration [%s] = [%b]", new Object[]{"antublue.test.engine.console.log.test.messages", this.consoleLogTestMessages});
        this.consoleLogPassMessages = configuration.getBoolean("antublue.test.engine.console.log.pass.messages").orElse(true);
        LOGGER.trace("configuration [%s] = [%b]", new Object[]{"antublue.test.engine.console.log.pass.messages", this.consoleLogPassMessages});
        this.consoleLogSkipMessages = configuration.getBoolean("antublue.test.engine.console.log.skip.messages").orElse(true);
        LOGGER.trace("configuration [%s] = [%b]", new Object[]{"antublue.test.engine.console.log.skip.messages", this.consoleLogSkipMessages});
        this.consoleTestMessage = new AnsiColorStringBuilder().append((Object)AnsiColor.TEXT_WHITE_BRIGHT).append(configuration.get("antublue.test.engine.console.log.test.message").orElse("TEST")).color(AnsiColor.TEXT_RESET).toString();
        this.consolePassMessage = new AnsiColorStringBuilder().color(AnsiColor.TEXT_GREEN_BOLD_BRIGHT).append(configuration.get("antublue.test.engine.console.log.pass.message").orElse("PASS")).color(AnsiColor.TEXT_RESET).toString();
        this.consoleSkipMessage = new AnsiColorStringBuilder().color(AnsiColor.TEXT_YELLOW_BOLD_BRIGHT).append(configuration.get("antublue.test.engine.console.log.skip.message").orElse("SKIP")).color(AnsiColor.TEXT_RESET).toString();
        this.consoleFailMessage = new AnsiColorStringBuilder().color(AnsiColor.TEXT_RED_BOLD_BRIGHT).append(configuration.get("antublue.test.engine.console.log.fail.message").orElse("FAIL")).color(AnsiColor.TEXT_RESET).toString();
    }

    public void executionStarted(TestDescriptor testDescriptor) {
        if (this.consoleLogTestMessages && testDescriptor instanceof Metadata) {
            Metadata metadata = (Metadata)testDescriptor;
            MetadataInformation metadataInformation = metadata.getMetadata();
            Class testClass = (Class)metadataInformation.get("testClass");
            String testClassDisplayName = (String)metadataInformation.get("testClass.displayName");
            Method testMethod = (Method)metadataInformation.get("testMethod");
            String testMethodDisplayName = metadataInformation.get("testMethod.displayName") + "()";
            Argument testArgument = (Argument)metadataInformation.get("testArgument");
            AnsiColorStringBuilder ansiColorStringBuilder = new AnsiColorStringBuilder().append(INFO).append(" ").append(Thread.currentThread().getName()).append(" | ").append(this.consoleTestMessage).color(AnsiColor.TEXT_RESET);
            if (testArgument != null) {
                ansiColorStringBuilder.append(" | ").append(testArgument.getName());
            }
            if (testClass != null) {
                ansiColorStringBuilder.append(" | ").append(testClassDisplayName);
            }
            if (testMethod != null) {
                ansiColorStringBuilder.append(" | ").append(testMethodDisplayName);
            }
            ansiColorStringBuilder.color(AnsiColor.TEXT_RESET);
            System.out.println(ansiColorStringBuilder);
            System.out.flush();
        }
    }

    public void executionSkipped(TestDescriptor testDescriptor, String reason) {
        if (this.consoleLogSkipMessages && testDescriptor instanceof Metadata) {
            Metadata metadata = (Metadata)testDescriptor;
            MetadataInformation metadataInformation = metadata.getMetadata();
            Class testClass = (Class)metadataInformation.get("testClass");
            String testClassDisplayName = (String)metadataInformation.get("testClass.displayName");
            Argument testArgument = (Argument)metadataInformation.get("testArgument");
            Method testMethod = (Method)metadataInformation.get("testMethod");
            String testMethodDisplayName = metadataInformation.get("testMethod.displayName") + "()";
            Long elapsedTime = (Long)metadataInformation.get("testDescriptorElapsedTime");
            AnsiColorStringBuilder ansiColorStringBuilder = new AnsiColorStringBuilder().append(INFO).append(" ").append(Thread.currentThread().getName()).append(" | ").append((Object)AnsiColor.TEXT_WHITE_BRIGHT);
            ansiColorStringBuilder.append(this.consoleSkipMessage).color(AnsiColor.TEXT_RESET);
            if (testArgument != null) {
                ansiColorStringBuilder.append(" | ").append(testArgument.getName());
            }
            if (testClass != null) {
                ansiColorStringBuilder.append(" | ").append(testClassDisplayName);
            }
            if (testMethod != null) {
                ansiColorStringBuilder.append(" | ").append(testMethodDisplayName);
            }
            if (this.consoleLogTiming && elapsedTime != null) {
                ansiColorStringBuilder.append(" ").append(HumanReadableTimeUtils.toTimingUnit((long)elapsedTime, (String)this.consoleLogTimingUnits));
            }
            ansiColorStringBuilder.color(AnsiColor.TEXT_RESET);
            System.out.println(ansiColorStringBuilder);
            System.out.flush();
        }
    }

    public void executionFinished(TestDescriptor testDescriptor, TestExecutionResult testExecutionResult) {
        if (this.consoleLogPassMessages && testDescriptor instanceof Metadata) {
            Metadata metadata = (Metadata)testDescriptor;
            MetadataInformation metadataInformation = metadata.getMetadata();
            Class testClass = (Class)metadataInformation.get("testClass");
            String testClassDisplayName = (String)metadataInformation.get("testClass.displayName");
            Argument testArgument = (Argument)metadataInformation.get("testArgument");
            Method testMethod = (Method)metadataInformation.get("testMethod");
            String testMethodDisplayName = metadataInformation.get("testMethod.displayName") + "()";
            Long elapsedTime = (Long)metadataInformation.get("testDescriptorElapsedTime");
            String testDescriptorStatus = (String)metadataInformation.get("testDescriptorStatus");
            AnsiColorStringBuilder ansiColorStringBuilder = new AnsiColorStringBuilder().append(INFO).append(" ").append(Thread.currentThread().getName()).append(" | ").append((Object)AnsiColor.TEXT_WHITE_BRIGHT);
            switch (testDescriptorStatus) {
                case "PASS": {
                    ansiColorStringBuilder.append(this.consolePassMessage);
                    break;
                }
                case "FAIL": {
                    ansiColorStringBuilder.append(this.consoleFailMessage);
                    break;
                }
                case "SKIP": {
                    ansiColorStringBuilder.append(this.consoleSkipMessage);
                    break;
                }
                default: {
                    ansiColorStringBuilder.append(AnsiColor.TEXT_CYAN_BOLD.wrap((Object)"????"));
                }
            }
            ansiColorStringBuilder.color(AnsiColor.TEXT_RESET);
            if (testArgument != null) {
                ansiColorStringBuilder.append(" | ").append(testArgument.getName());
            }
            if (testClass != null) {
                ansiColorStringBuilder.append(" | ").append(testClassDisplayName);
            }
            if (testMethod != null) {
                ansiColorStringBuilder.append(" | ").append(testMethodDisplayName);
            }
            if (this.consoleLogTiming && elapsedTime != null) {
                ansiColorStringBuilder.append(" ").append(HumanReadableTimeUtils.toTimingUnit((long)elapsedTime, (String)this.consoleLogTimingUnits));
            }
            ansiColorStringBuilder.color(AnsiColor.TEXT_RESET);
            System.out.println(ansiColorStringBuilder);
            System.out.flush();
        }
    }
}

