/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.maven.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Information {
    private static final String RESOURCE_PATH = "/test-engine-maven-plugin.properties";
    private static final String VERSION = "version";
    private static final String UNKNOWN = "Unknown";

    private Information() {
    }

    public static Information getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public String getVersion() {
        return this.getProperty(VERSION, UNKNOWN);
    }

    private String getProperty(String key, String defaultValue) {
        String value = defaultValue;
        try (InputStream inputStream = Information.class.getResourceAsStream(RESOURCE_PATH);){
            if (inputStream != null) {
                Properties properties = new Properties();
                properties.load(inputStream);
                value = properties.getProperty(key, defaultValue).trim();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return value;
    }

    private static final class SingletonHolder {
        private static final Information INSTANCE = new Information();

        private SingletonHolder() {
        }
    }
}

