/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.ppp;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.logging.Logger;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlTransient;
import org.jvnet.jaxb2_commons.ppp.Child;
import org.xml.sax.ErrorHandler;

public class ParentPointerPlugin
extends Plugin {
    private static final String className = Plugin.class.getName();
    private static final Logger logger = Logger.getLogger(className);
    private static final String parentFieldName = "parent";
    private static final String parentGetterName = "getParent";
    private static final String parentSetterName = "setParent";
    private static final String unmarshalCallbackName = "afterUnmarshal";

    public String getOptionName() {
        return "Xparent-pointer";
    }

    public String getUsage() {
        return "-Xparent-pointer : Add a field that points to the parent object.";
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        logger.entering(className, "run");
        for (ClassOutline classOutline : outline.getClasses()) {
            this.implementChild(outline, classOutline.implClass);
            this.addUnmarshalCallback(outline, classOutline.implClass);
        }
        logger.exiting(className, "run", true);
        return true;
    }

    private void addParentField(JDefinedClass definedClass) {
        logger.entering(className, "addParentField");
        JFieldVar parentField = definedClass.field(4, Object.class, parentFieldName);
        parentField.annotate(XmlTransient.class);
        logger.exiting(className, "addParentField");
    }

    private void addParentGetter(Outline outline, JDefinedClass definedClass) {
        logger.entering(className, "addParentGetter");
        JMethod getParentMethod = definedClass.method(1, Object.class, parentGetterName);
        getParentMethod.body()._return((JExpression)JExpr.ref((JExpression)JExpr._this(), (String)parentFieldName));
        getParentMethod.javadoc().append((Object)"Gets the parent object in the object tree representing the unmarshalled xml document.");
        getParentMethod.javadoc().addReturn().append((Object)"The parent object.");
        logger.exiting(className, "addParentGetter");
    }

    private void addParentSetter(Outline outline, JDefinedClass definedClass) {
        logger.entering(className, "addParentSetter");
        JMethod setParentMethod = definedClass.method(1, (JType)outline.getCodeModel().VOID, parentSetterName);
        JVar parentSetterVar = setParentMethod.param(Object.class, parentFieldName);
        setParentMethod.body().assign((JAssignmentTarget)JExpr.ref((JExpression)JExpr._this(), (String)parentFieldName), (JExpression)parentSetterVar);
        logger.exiting(className, "addParentSetter");
    }

    private void addUnmarshalCallback(Outline outline, JDefinedClass definedClass) {
        logger.entering(className, "addUnmarshalCallback");
        JMethod afterUnmarshalMethod = definedClass.method(1, (JType)outline.getCodeModel().VOID, unmarshalCallbackName);
        JVar unmarshallerVar = afterUnmarshalMethod.param(Unmarshaller.class, "unmarshaller");
        JVar parentVar = afterUnmarshalMethod.param(Object.class, parentFieldName);
        afterUnmarshalMethod.body().invoke(parentSetterName).arg((JExpression)parentVar);
        afterUnmarshalMethod.javadoc().append((Object)"This method is invoked by the JAXB implementation on each instance when unmarshalling completes.");
        afterUnmarshalMethod.javadoc().addParam(unmarshallerVar).append((Object)"The unmarshaller that generated the instance.");
        afterUnmarshalMethod.javadoc().addParam(parentVar).append((Object)"The parent object in the object tree.");
        logger.exiting(className, "addUnmarshalCallback");
    }

    private void implementChild(Outline outline, JDefinedClass definedClass) {
        logger.entering(className, "implementChild");
        definedClass._implements(Child.class);
        this.addParentField(definedClass);
        this.addParentGetter(outline, definedClass);
        this.addParentSetter(outline, definedClass);
        logger.exiting(className, "implementChild");
    }
}

