// Generated by forms/ActionForm.java.vsl in cartridge andromda-bpm4struts
// license-header java merge-point
package org.andromda.samples.carrental.contracts.web.reserveCar;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.ValidatorForm;

public class ReserveACarReserveFormImpl
    extends ValidatorForm
    implements Serializable
        , ReserveForm
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -7706109281L;

    private String comfortClass;
    private Object[] comfortClassValueList;
    private Object[] comfortClassLabelList;
    private Date reservationDate;
    private static final DateFormat reservationDateDateFormatter = new SimpleDateFormat("MM/dd/yyyy");
    private Object[] reservationDateValueList;
    private Object[] reservationDateLabelList;

    public ReserveACarReserveFormImpl()
    {
        reservationDateDateFormatter.setLenient(true);
    }

    /**
     * Resets the given <code>comfortClass</code>.
     */
    public void resetComfortClass()
    {
        this.comfortClass = null;
    }

    public void setComfortClass(String comfortClass)
    {
        this.comfortClass = comfortClass;
    }

    /**
     * <p>
     * Comfort Class of the car
     * </p>
     */
    public String getComfortClass()
    {
        return this.comfortClass;
    }

    public Object[] getComfortClassBackingList()
    {
        Object[] values = this.comfortClassValueList;
        Object[] labels = this.comfortClassLabelList;

        if (values == null || values.length == 0)
        {
            return values;
        }

        if (labels == null || labels.length == 0)
        {
            labels = values;
        }

        final int length = Math.min(labels.length, values.length);
        Object[] backingList = new Object[length];

        for (int i=0; i<length; i++)
        {
            backingList[i] = new LabelValue(labels[i], values[i]);
        }

        return backingList;
    }

    public Object[] getComfortClassValueList()
    {
        return this.comfortClassValueList;
    }

    public void setComfortClassValueList(Object[] comfortClassValueList)
    {
        this.comfortClassValueList = comfortClassValueList;
    }

    public Object[] getComfortClassLabelList()
    {
        return this.comfortClassLabelList;
    }

    public void setComfortClassLabelList(Object[] comfortClassLabelList)
    {
        this.comfortClassLabelList = comfortClassLabelList;
    }

    public void setComfortClassBackingList(Collection items, String valueProperty, String labelProperty)
    {
        if (valueProperty == null || labelProperty == null)
        {
            throw new IllegalArgumentException("ReserveACarReserveFormImpl.setComfortClassBackingList requires non-null property arguments");
        }

        this.comfortClassValueList = null;
        this.comfortClassLabelList = null;

        if (items != null)
        {
            this.comfortClassValueList = new Object[items.size()];
            this.comfortClassLabelList = new Object[items.size()];

            try
            {
                int i = 0;
                for (Iterator iterator = items.iterator(); iterator.hasNext(); i++)
                {
                    final Object item = iterator.next();

                    this.comfortClassValueList[i] = PropertyUtils.getProperty(item, valueProperty);
                    this.comfortClassLabelList[i] = PropertyUtils.getProperty(item, labelProperty);
                }
            }
            catch (Exception ex)
            {
                throw new RuntimeException("ReserveACarReserveFormImpl.setComfortClassBackingList encountered an exception", ex);
            }
        }
    }

    /**
     * Resets the given <code>reservationDate</code>.
     */
    public void resetReservationDate()
    {
        this.reservationDate = null;
    }

    public void setReservationDateAsDate(Date reservationDate)
    {
        this.reservationDate = reservationDate;
    }

    /**
     * Returns the Date instance representing the <code>reservationDate</code> field.
     *
     * @see org.andromda.samples.carrental.contracts.web.reserveCar.ReserveACarReserveFormImpl#getReservationDate
     * @see org.andromda.samples.carrental.contracts.web.reserveCar.ReserveACarReserveFormImpl#reservationDateDateFormatter
     */
    public Date getReservationDateAsDate()
    {
        return this.reservationDate;
    }

    public void setReservationDate(String reservationDate)
    {
        if (reservationDate == null || reservationDate.trim().length() == 0)
        {
            this.reservationDate = null;
        }
        else
        {
            try
            {
                this.reservationDate = reservationDateDateFormatter.parse(reservationDate);
            }
            catch(ParseException e)
            {
                // we are not throwing an exception, let the validator handle these cases
                this.reservationDate = null;
            }
        }
    }

    /**
     * <p>
     * Day to pick up the car
     * </p>
     *
     * This method returns a <code>String</code> instance, in order to get the
     * <code>Date</code> instance see the <code>getReservationDateAsDate()</code>
     * method.
     * <p>
     * The conversion from Date to String (and vice-versa) is done by means of a date formatter, which
     * can be accessed here: <code>getReservationDateDateFormatter()</code>.
     *
     * @see org.andromda.samples.carrental.contracts.web.reserveCar.ReserveACarReserveFormImpl#getReservationDateAsDate
     * @see org.andromda.samples.carrental.contracts.web.reserveCar.ReserveACarReserveFormImpl#getReservationDateDateFormatter
     */
    public String getReservationDate()
    {
        return (reservationDate == null) ? null : reservationDateDateFormatter.format(reservationDate);
    }

    /**
     * Returns the date formatter used for the <code>reservationDate</code> property.
     *
     * @see org.andromda.samples.carrental.contracts.web.reserveCar.ReserveACarReserveFormImpl#getReservationDate
     * @see org.andromda.samples.carrental.contracts.web.reserveCar.ReserveACarReserveFormImpl#getReservationDateAsDate
     */
    public static DateFormat getReservationDateDateFormatter()
    {
        return ReserveACarReserveFormImpl.reservationDateDateFormatter;
    }

    public Object[] getReservationDateBackingList()
    {
        Object[] values = this.reservationDateValueList;
        Object[] labels = this.reservationDateLabelList;

        if (values == null || values.length == 0)
        {
            return values;
        }

        if (labels == null || labels.length == 0)
        {
            labels = values;
        }

        final int length = Math.min(labels.length, values.length);
        Object[] backingList = new Object[length];

        for (int i=0; i<length; i++)
        {
            backingList[i] = new LabelValue(labels[i], values[i]);
        }

        return backingList;
    }

    public Object[] getReservationDateValueList()
    {
        return this.reservationDateValueList;
    }

    public void setReservationDateValueList(Object[] reservationDateValueList)
    {
        this.reservationDateValueList = reservationDateValueList;
    }

    public Object[] getReservationDateLabelList()
    {
        return this.reservationDateLabelList;
    }

    public void setReservationDateLabelList(Object[] reservationDateLabelList)
    {
        this.reservationDateLabelList = reservationDateLabelList;
    }

    public void setReservationDateBackingList(Collection items, String valueProperty, String labelProperty)
    {
        if (valueProperty == null || labelProperty == null)
        {
            throw new IllegalArgumentException("ReserveACarReserveFormImpl.setReservationDateBackingList requires non-null property arguments");
        }

        this.reservationDateValueList = null;
        this.reservationDateLabelList = null;

        if (items != null)
        {
            this.reservationDateValueList = new Object[items.size()];
            this.reservationDateLabelList = new Object[items.size()];

            try
            {
                int i = 0;
                for (Iterator iterator = items.iterator(); iterator.hasNext(); i++)
                {
                    final Object item = iterator.next();

                    this.reservationDateValueList[i] = PropertyUtils.getProperty(item, valueProperty);
                    this.reservationDateLabelList[i] = PropertyUtils.getProperty(item, labelProperty);
                }
            }
            catch (Exception ex)
            {
                throw new RuntimeException("ReserveACarReserveFormImpl.setReservationDateBackingList encountered an exception", ex);
            }
        }
    }

    /**
     * @see ValidatorForm#reset(ActionMapping,HttpServletRequest)
     */
    public void reset(ActionMapping mapping, HttpServletRequest request)
    {
        this.comfortClass = null;
    }

    public String toString()
    {
        ToStringBuilder builder =
            new ToStringBuilder(this);
        builder.append("comfortClass", this.comfortClass);
        builder.append("reservationDate", this.reservationDate);
        return builder.toString();
    }

    /**
     * Allows you to clean all values from this form. Objects will be set to <code>null</code>, numeric values will be
     * set to zero and boolean values will be set to <code>false</code>. Backinglists for selectable fields will
     * also be set to <code>null</code>.
     */
    public void clean()
    {
        this.comfortClass = null;
        this.comfortClassValueList = null;
        this.comfortClassLabelList = null;
        this.reservationDate = null;
        this.reservationDateValueList = null;
        this.reservationDateLabelList = null;
    }

    /**
     * Override to provide population of current form with request parameters when validation fails.
     *
     * @see org.apache.struts.action.ActionForm#validate(ActionMapping, HttpServletRequest)
     */
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request)
    {
        final ActionErrors errors = super.validate(mapping, request);
        if (errors != null && !errors.isEmpty())
        {
            // we populate the current form with only the request parameters
            Object currentForm = request.getSession().getAttribute("form");
            // if we can't get the 'form' from the session, try from the request
            if (currentForm == null)
            {
                currentForm = request.getAttribute("form");
            }
            if (currentForm != null)
            {
                final Map parameters = new HashMap();
                for (final Enumeration names = request.getParameterNames(); names.hasMoreElements();)
                {
                    final String name = String.valueOf(names.nextElement());
                    final String[] values = request.getParameterValues(name);

                    if (values.length == 1)
                    {
                        parameters.put(name, values[0]);
                    }
                    else
                    {
                        parameters.put(name, values);
                    }
                }
                try
                {
                    BeanUtils.populate(currentForm, parameters);
                }
                catch (Exception populateException)
                {
                    // ignore if we have an exception here (we just don't populate).
                }
            }
        }
        return errors;
    }

    public static final class LabelValue
    {
        private Object label = null;
        private Object value = null;

        public LabelValue(Object label, Object value)
        {
            this.label = label;
            this.value = value;
        }

        public Object getLabel()
        {
            return this.label;
        }

        public Object getValue()
        {
            return this.value;
        }

        public String toString()
        {
            return label + "=" + value;
        }
    }
}