// Generated by forms/ActionForm.java.vsl in cartridge andromda-bpm4struts
// license-header java merge-point
package org.andromda.samples.carrental.contracts.web.reserveCar;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.ValidatorForm;

public class CustomerReservesCarFormImpl
    extends ValidatorForm
    implements Serializable
        , SearchForReservationsForm
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 8699464301L;

    private String comfortClass;
    private Object[] comfortClassValueList;
    private Object[] comfortClassLabelList;
    private Date reservationDate;
    private static final DateFormat reservationDateDateFormatter = new SimpleDateFormat("MM/dd/yyyy");
    private Object[] reservationDateValueList;
    private Object[] reservationDateLabelList;
    private String idReservation;
    private Object[] idReservationValueList;
    private Object[] idReservationLabelList;
    private Collection reservations = null;
    private Object[] reservationsValueList;
    private Object[] reservationsLabelList;

    public CustomerReservesCarFormImpl()
    {
        reservationDateDateFormatter.setLenient(true);
    }

    /**
     * Resets the given <code>comfortClass</code>.
     */
    public void resetComfortClass()
    {
        this.comfortClass = null;
    }

    public void setComfortClass(String comfortClass)
    {
        this.comfortClass = comfortClass;
    }

    /**
     * <p>
     * Comfort Class of the car
     * </p>
     */
    public String getComfortClass()
    {
        return this.comfortClass;
    }

    public Object[] getComfortClassBackingList()
    {
        Object[] values = this.comfortClassValueList;
        Object[] labels = this.comfortClassLabelList;

        if (values == null || values.length == 0)
        {
            return values;
        }

        if (labels == null || labels.length == 0)
        {
            labels = values;
        }

        final int length = Math.min(labels.length, values.length);
        Object[] backingList = new Object[length];

        for (int i=0; i<length; i++)
        {
            backingList[i] = new LabelValue(labels[i], values[i]);
        }

        return backingList;
    }

    public Object[] getComfortClassValueList()
    {
        return this.comfortClassValueList;
    }

    public void setComfortClassValueList(Object[] comfortClassValueList)
    {
        this.comfortClassValueList = comfortClassValueList;
    }

    public Object[] getComfortClassLabelList()
    {
        return this.comfortClassLabelList;
    }

    public void setComfortClassLabelList(Object[] comfortClassLabelList)
    {
        this.comfortClassLabelList = comfortClassLabelList;
    }

    public void setComfortClassBackingList(Collection items, String valueProperty, String labelProperty)
    {
        if (valueProperty == null || labelProperty == null)
        {
            throw new IllegalArgumentException("CustomerReservesCarFormImpl.setComfortClassBackingList requires non-null property arguments");
        }

        this.comfortClassValueList = null;
        this.comfortClassLabelList = null;

        if (items != null)
        {
            this.comfortClassValueList = new Object[items.size()];
            this.comfortClassLabelList = new Object[items.size()];

            try
            {
                int i = 0;
                for (Iterator iterator = items.iterator(); iterator.hasNext(); i++)
                {
                    final Object item = iterator.next();

                    this.comfortClassValueList[i] = PropertyUtils.getProperty(item, valueProperty);
                    this.comfortClassLabelList[i] = PropertyUtils.getProperty(item, labelProperty);
                }
            }
            catch (Exception ex)
            {
                throw new RuntimeException("CustomerReservesCarFormImpl.setComfortClassBackingList encountered an exception", ex);
            }
        }
    }

    /**
     * Resets the given <code>reservationDate</code>.
     */
    public void resetReservationDate()
    {
        this.reservationDate = null;
    }

    public void setReservationDateAsDate(Date reservationDate)
    {
        this.reservationDate = reservationDate;
    }

    /**
     * Returns the Date instance representing the <code>reservationDate</code> field.
     *
     * @see org.andromda.samples.carrental.contracts.web.reserveCar.CustomerReservesCarFormImpl#getReservationDate
     * @see org.andromda.samples.carrental.contracts.web.reserveCar.CustomerReservesCarFormImpl#reservationDateDateFormatter
     */
    public Date getReservationDateAsDate()
    {
        return this.reservationDate;
    }

    public void setReservationDate(String reservationDate)
    {
        if (reservationDate == null || reservationDate.trim().length() == 0)
        {
            this.reservationDate = null;
        }
        else
        {
            try
            {
                this.reservationDate = reservationDateDateFormatter.parse(reservationDate);
            }
            catch(ParseException e)
            {
                // we are not throwing an exception, let the validator handle these cases
                this.reservationDate = null;
            }
        }
    }

    /**
     * <p>
     * Day to pick up the car
     * </p>
     *
     * This method returns a <code>String</code> instance, in order to get the
     * <code>Date</code> instance see the <code>getReservationDateAsDate()</code>
     * method.
     * <p>
     * The conversion from Date to String (and vice-versa) is done by means of a date formatter, which
     * can be accessed here: <code>getReservationDateDateFormatter()</code>.
     *
     * @see org.andromda.samples.carrental.contracts.web.reserveCar.CustomerReservesCarFormImpl#getReservationDateAsDate
     * @see org.andromda.samples.carrental.contracts.web.reserveCar.CustomerReservesCarFormImpl#getReservationDateDateFormatter
     */
    public String getReservationDate()
    {
        return (reservationDate == null) ? null : reservationDateDateFormatter.format(reservationDate);
    }

    /**
     * Returns the date formatter used for the <code>reservationDate</code> property.
     *
     * @see org.andromda.samples.carrental.contracts.web.reserveCar.CustomerReservesCarFormImpl#getReservationDate
     * @see org.andromda.samples.carrental.contracts.web.reserveCar.CustomerReservesCarFormImpl#getReservationDateAsDate
     */
    public static DateFormat getReservationDateDateFormatter()
    {
        return CustomerReservesCarFormImpl.reservationDateDateFormatter;
    }

    public Object[] getReservationDateBackingList()
    {
        Object[] values = this.reservationDateValueList;
        Object[] labels = this.reservationDateLabelList;

        if (values == null || values.length == 0)
        {
            return values;
        }

        if (labels == null || labels.length == 0)
        {
            labels = values;
        }

        final int length = Math.min(labels.length, values.length);
        Object[] backingList = new Object[length];

        for (int i=0; i<length; i++)
        {
            backingList[i] = new LabelValue(labels[i], values[i]);
        }

        return backingList;
    }

    public Object[] getReservationDateValueList()
    {
        return this.reservationDateValueList;
    }

    public void setReservationDateValueList(Object[] reservationDateValueList)
    {
        this.reservationDateValueList = reservationDateValueList;
    }

    public Object[] getReservationDateLabelList()
    {
        return this.reservationDateLabelList;
    }

    public void setReservationDateLabelList(Object[] reservationDateLabelList)
    {
        this.reservationDateLabelList = reservationDateLabelList;
    }

    public void setReservationDateBackingList(Collection items, String valueProperty, String labelProperty)
    {
        if (valueProperty == null || labelProperty == null)
        {
            throw new IllegalArgumentException("CustomerReservesCarFormImpl.setReservationDateBackingList requires non-null property arguments");
        }

        this.reservationDateValueList = null;
        this.reservationDateLabelList = null;

        if (items != null)
        {
            this.reservationDateValueList = new Object[items.size()];
            this.reservationDateLabelList = new Object[items.size()];

            try
            {
                int i = 0;
                for (Iterator iterator = items.iterator(); iterator.hasNext(); i++)
                {
                    final Object item = iterator.next();

                    this.reservationDateValueList[i] = PropertyUtils.getProperty(item, valueProperty);
                    this.reservationDateLabelList[i] = PropertyUtils.getProperty(item, labelProperty);
                }
            }
            catch (Exception ex)
            {
                throw new RuntimeException("CustomerReservesCarFormImpl.setReservationDateBackingList encountered an exception", ex);
            }
        }
    }

    /**
     * Resets the given <code>idReservation</code>.
     */
    public void resetIdReservation()
    {
        this.idReservation = null;
    }

    public void setIdReservation(String idReservation)
    {
        this.idReservation = idReservation;
    }

    /**
     * 
     */
    public String getIdReservation()
    {
        return this.idReservation;
    }

    public Object[] getIdReservationBackingList()
    {
        Object[] values = this.idReservationValueList;
        Object[] labels = this.idReservationLabelList;

        if (values == null || values.length == 0)
        {
            return values;
        }

        if (labels == null || labels.length == 0)
        {
            labels = values;
        }

        final int length = Math.min(labels.length, values.length);
        Object[] backingList = new Object[length];

        for (int i=0; i<length; i++)
        {
            backingList[i] = new LabelValue(labels[i], values[i]);
        }

        return backingList;
    }

    public Object[] getIdReservationValueList()
    {
        return this.idReservationValueList;
    }

    public void setIdReservationValueList(Object[] idReservationValueList)
    {
        this.idReservationValueList = idReservationValueList;
    }

    public Object[] getIdReservationLabelList()
    {
        return this.idReservationLabelList;
    }

    public void setIdReservationLabelList(Object[] idReservationLabelList)
    {
        this.idReservationLabelList = idReservationLabelList;
    }

    public void setIdReservationBackingList(Collection items, String valueProperty, String labelProperty)
    {
        if (valueProperty == null || labelProperty == null)
        {
            throw new IllegalArgumentException("CustomerReservesCarFormImpl.setIdReservationBackingList requires non-null property arguments");
        }

        this.idReservationValueList = null;
        this.idReservationLabelList = null;

        if (items != null)
        {
            this.idReservationValueList = new Object[items.size()];
            this.idReservationLabelList = new Object[items.size()];

            try
            {
                int i = 0;
                for (Iterator iterator = items.iterator(); iterator.hasNext(); i++)
                {
                    final Object item = iterator.next();

                    this.idReservationValueList[i] = PropertyUtils.getProperty(item, valueProperty);
                    this.idReservationLabelList[i] = PropertyUtils.getProperty(item, labelProperty);
                }
            }
            catch (Exception ex)
            {
                throw new RuntimeException("CustomerReservesCarFormImpl.setIdReservationBackingList encountered an exception", ex);
            }
        }
    }

    /**
     * Resets the given <code>reservations</code>.
     */
    public void resetReservations()
    {
        this.reservations = null;
    }

    public void setReservations(Collection reservations)
    {
        this.reservations = reservations;
    }

    /**
     * 
     */
    public Collection getReservations()
    {
        return this.reservations;
    }

    public void setReservationsAsArray(Object[] reservations)
    {
        this.reservations = (reservations == null) ? null : Arrays.asList(reservations);
    }

    /**
     * Returns this collection as an array, if the collection itself would be <code>null</code> this method
     * will also return <code>null</code>.
     *
     * @see org.andromda.samples.carrental.contracts.web.reserveCar.CustomerReservesCarFormImpl#getReservations
     */
    public Object[] getReservationsAsArray()
    {
        return (reservations == null) ? null : reservations.toArray();
    }

    public Object[] getReservationsBackingList()
    {
        Object[] values = this.reservationsValueList;
        Object[] labels = this.reservationsLabelList;

        if (values == null || values.length == 0)
        {
            return values;
        }

        if (labels == null || labels.length == 0)
        {
            labels = values;
        }

        final int length = Math.min(labels.length, values.length);
        Object[] backingList = new Object[length];

        for (int i=0; i<length; i++)
        {
            backingList[i] = new LabelValue(labels[i], values[i]);
        }

        return backingList;
    }

    public Object[] getReservationsValueList()
    {
        return this.reservationsValueList;
    }

    public void setReservationsValueList(Object[] reservationsValueList)
    {
        this.reservationsValueList = reservationsValueList;
    }

    public Object[] getReservationsLabelList()
    {
        return this.reservationsLabelList;
    }

    public void setReservationsLabelList(Object[] reservationsLabelList)
    {
        this.reservationsLabelList = reservationsLabelList;
    }

    public void setReservationsBackingList(Collection items, String valueProperty, String labelProperty)
    {
        if (valueProperty == null || labelProperty == null)
        {
            throw new IllegalArgumentException("CustomerReservesCarFormImpl.setReservationsBackingList requires non-null property arguments");
        }

        this.reservationsValueList = null;
        this.reservationsLabelList = null;

        if (items != null)
        {
            this.reservationsValueList = new Object[items.size()];
            this.reservationsLabelList = new Object[items.size()];

            try
            {
                int i = 0;
                for (Iterator iterator = items.iterator(); iterator.hasNext(); i++)
                {
                    final Object item = iterator.next();

                    this.reservationsValueList[i] = PropertyUtils.getProperty(item, valueProperty);
                    this.reservationsLabelList[i] = PropertyUtils.getProperty(item, labelProperty);
                }
            }
            catch (Exception ex)
            {
                throw new RuntimeException("CustomerReservesCarFormImpl.setReservationsBackingList encountered an exception", ex);
            }
        }
    }

    /**
     * @see ValidatorForm#reset(ActionMapping,HttpServletRequest)
     */
    public void reset(ActionMapping mapping, HttpServletRequest request)
    {
        this.comfortClass = null;
    }

    public String toString()
    {
        ToStringBuilder builder =
            new ToStringBuilder(this);
        builder.append("comfortClass", this.comfortClass);
        builder.append("reservationDate", this.reservationDate);
        builder.append("idReservation", this.idReservation);
        builder.append("reservations", this.reservations);
        return builder.toString();
    }

    /**
     * Allows you to clean all values from this form. Objects will be set to <code>null</code>, numeric values will be
     * set to zero and boolean values will be set to <code>false</code>. Backinglists for selectable fields will
     * also be set to <code>null</code>.
     */
    public void clean()
    {
        this.comfortClass = null;
        this.comfortClassValueList = null;
        this.comfortClassLabelList = null;
        this.reservationDate = null;
        this.reservationDateValueList = null;
        this.reservationDateLabelList = null;
        this.idReservation = null;
        this.idReservationValueList = null;
        this.idReservationLabelList = null;
        this.reservations = null;
        this.reservationsValueList = null;
        this.reservationsLabelList = null;
    }

    /**
     * Override to provide population of current form with request parameters when validation fails.
     *
     * @see org.apache.struts.action.ActionForm#validate(ActionMapping, HttpServletRequest)
     */
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request)
    {
        final ActionErrors errors = super.validate(mapping, request);
        if (errors != null && !errors.isEmpty())
        {
            // we populate the current form with only the request parameters
            Object currentForm = request.getSession().getAttribute("form");
            // if we can't get the 'form' from the session, try from the request
            if (currentForm == null)
            {
                currentForm = request.getAttribute("form");
            }
            if (currentForm != null)
            {
                final Map parameters = new HashMap();
                for (final Enumeration names = request.getParameterNames(); names.hasMoreElements();)
                {
                    final String name = String.valueOf(names.nextElement());
                    final String[] values = request.getParameterValues(name);

                    if (values.length == 1)
                    {
                        parameters.put(name, values[0]);
                    }
                    else
                    {
                        parameters.put(name, values);
                    }
                }
                try
                {
                    BeanUtils.populate(currentForm, parameters);
                }
                catch (Exception populateException)
                {
                    // ignore if we have an exception here (we just don't populate).
                }
            }
        }
        return errors;
    }

    public static final class LabelValue
    {
        private Object label = null;
        private Object value = null;

        public LabelValue(Object label, Object value)
        {
            this.label = label;
            this.value = value;
        }

        public Object getLabel()
        {
            return this.label;
        }

        public Object getValue()
        {
            return this.value;
        }

        public String toString()
        {
            return label + "=" + value;
        }
    }
}