// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringService.vsl in andromda-spring-cartridge.
//
/**
 * TEMPLATE:    SpringService.vsl in andromda-spring cartridge
 * MODEL CLASS: org::andromda::samples::carrental::inventory::InventoryService
 * STEREOTYPE:  Service
 */
package org.andromda.samples.carrental.inventory;

import java.util.Collection;

/**
 * <p>
 * Supports the workflow of inventory management for the car rental
 * company.
 * </p>
 * <p>
 * Can create types of cars, can create cars and search for all
 * these objects.
 * </p>
 */
public interface InventoryService
{
    /**
     * <p>
     * Creates a car type (kind of catalog entry).
     * </p>
     * <p>
     * @param typeData the data for the catalog entry
     * </p>
     * <p>
     * @return a String with the id of the CarType object
     * </p>
     * @param typeData 
     * @return  String
     * @throws InventoryException
     */
    public String createCarType(CarTypeData typeData)
        throws InventoryException;

    /**
     * <p>
     * Creates a car with a certain type. The car type must already
     * exist.
     * </p>
     * <p>
     * @param carData data for the Car object
     * </p>
     * <p>
     * @param carTypeId the id of the CarType object
     * </p>
     * <p>
     * @return a String with the id of the Car object
     * </p>
     * @param carData 
     * @param carTypeId 
     * @return  String
     * @throws InventoryException
     */
    public String createCar(CarData carData, String carTypeId)
        throws InventoryException;

    /**
     * <p>
     * Searches all cars with a certain comfort class.
     * </p>
     * <p>
     * @param comfortClass the comfort class to search for
     * </p>
     * <p>
     * @return a Collection with CarData objects
     * </p>
     * @param comfortClass 
     * @return  Collection
     * @throws InventoryException
     */
    public Collection searchCarByComfortClass(String comfortClass)
        throws InventoryException;

    /**
     * <p>
     * Returns all registered car types from the catalog.
     * </p>
     * <p>
     * @return a Collection with CarTypeData objects.
     * </p>
     * @return  Collection
     * @throws InventoryException
     */
    public Collection searchAllCarTypes()
        throws InventoryException;

    /**
     * <p>
     * Returns all known cars.
     * </p>
     * <p>
     * @return a Collection with CarData objects
     * </p>
     * @return  Collection
     * @throws InventoryException
     */
    public Collection searchAllCars()
        throws InventoryException;

}