// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringService.vsl in andromda-spring-cartridge.
//
/**
 * TEMPLATE:    SpringService.vsl in andromda-spring cartridge
 * MODEL CLASS: org::andromda::samples::carrental::customers::CustomerService
 * STEREOTYPE:  Service
 */
package org.andromda.samples.carrental.customers;

import java.util.Collection;

/**
 * <p>
 * Supports the workflow of customer tasks in the system. Can
 * authenticate a user as a customer, can create customers, add
 * drivers to them and search for customers.
 * </p>
 */
public interface CustomerService
{
    /**
     * <p>
     * Creates a new customer.
     * </p>
     * <p>
     * @param name name of the new customer
     * </p>
     * <p>
     * @param customerNo customer number of the new customer
     * </p>
     * <p>
     * @return String with the customer id
     * </p>
     * @param name 
     * @param customerNo 
     * @param password 
     * @return  String
     * @throws CustomerException
     */
    public String createCustomer(String name, String customerNo, String password)
        throws CustomerException;

    /**
     * <p>
     * Adds a licensed driver to the drivers associated with a
     * particular customer.
     * </p>
     * <p>
     * @param customerId the id of the Customer object
     * </p>
     * <p>
     * @param driverData the data for the Driver to be created
     * </p>
     * <p>
     * @return a String with the Driver object's id
     * </p>
     * @param customerId 
     * @param driverData 
     * @return  String
     * @throws CustomerException
     */
    public String addDriver(String customerId, DriverData driverData)
        throws CustomerException;

    /**
     * <p>
     * Searches all customers.
     * </p>
     * <p>
     * @return a Collection with CustomerData objects.
     * </p>
     * @return  Collection
     * @throws CustomerException
     */
    public Collection searchAllCustomers()
        throws CustomerException;

    /**
     * <p>
     * Authenticates a user as a customer.
     * </p>
     * <p>
     * @return a String with the id of the Customer object.
     * </p>
     * <p>
     * @param customerNo the customer number
     * </p>
     * <p>
     * @param password the customer's password
     * </p>
     * @param customerNo 
     * @param password 
     * @return  String
     * @throws CustomerException
     */
    public String authenticateAsCustomer(String customerNo, String password)
        throws CustomerException;

}