// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringService.vsl in andromda-spring-cartridge.
//
/**
 * TEMPLATE:    SpringService.vsl in andromda-spring cartridge
 * MODEL CLASS: org::andromda::samples::carrental::contracts::ContractService
 * STEREOTYPE:  Service
 */
package org.andromda.samples.carrental.contracts;

import java.util.Collection;
import java.util.Date;

/**
 * <p>
 * Can place reservations and search for existing reservations.
 * </p>
 */
public interface ContractService
{
    /**
     * <p>
     * Searches all reservations for an existing customer.
     * </p>
     * <p>
     * @return Collection of ReservierungData objects
     * </p>
     * <p>
     * @param customerId the Id of the Customer object
     * </p>
     * @param customerId 
     * @return  Collection
     * @throws ContractException
     */
    public Collection searchForReservationsOfCustomer(String customerId)
        throws ContractException;

    /**
     * <p>
     * Reserves a car for a customer.
     * </p>
     * <p>
     * @param customerId the id of the Customer object
     * </p>
     * <p>
     * @param comfortClass indicates hom comfortable the car should be
     * ("eco", "normal", or "luxury")
     * </p>
     * <p>
     * @param reservationDate the day when the car is needed
     * </p>
     * @param customerId 
     * @param comfortClass 
     * @param reservationDate 
     * @return  void
     * @throws ContractException
     */
    public void reserve(String customerId, String comfortClass, Date reservationDate)
        throws ContractException;

    /**
     * <p>
     * Hand out a reservation of a car
     * </p>
     * <p>
     * @param idReservation the id of the reservation to Hand out
     * </p>
     * @param idReservation 
     * @return  String
     * @throws ContractException
     */
    public String handOutReservation(String idReservation)
        throws ContractException;

    /**
     * <p>
     * Return a car
     * </p>
     * <p>
     * @param idContract the Id of the Customer Contract
     * </p>
     * @param idContract 
     * @return  String
     * @throws ContractException
     */
    public String returnCar(String idContract)
        throws ContractException;

    /**
     * <p>
     * Searches all contracts for an existing customer.
     * </p>
     * <p>
     * @return Collection of ContractsData objects
     * </p>
     * <p>
     * @param customerId the Id of the Customer object
     * </p>
     * @param idCustomer 
     * @return  Collection
     * @throws ContractException
     */
    public Collection searchForContractsOfCustomer(String idCustomer)
        throws ContractException;

    /**
     * <p>
     * Register an accident from a customer with a Contract
     * </p>
     * <p>
     * @param idContract the Id of the Customer Contract
     * </p>
     * @param idContract 
     * @return  String
     * @throws ContractException
     */
    public String registerAccident(String idContract)
        throws ContractException;

}