// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringService.vsl in andromda-spring-cartridge.
//
/**
 * TEMPLATE:    SpringService.vsl in andromda-spring cartridge
 * MODEL CLASS: org::andromda::samples::carrental::admins::AdminService
 * STEREOTYPE:  Service
 */
package org.andromda.samples.carrental.admins;

/**
 * <p>
 * Can create administrative users of the application and
 * authenticate as such.
 * </p>
 * <p>
 * @author Matthias Bohlen
 * </p>
 */
public interface AdminService
{
    /**
     * <p>
     * Authenticates a user as administrator.
     * </p>
     * <p>
     * When there is no single object of this type in the database, the
     * method creates a new one and stores it. So, be careful to
     * remember the first password that you give!
     * </p>
     * <p>
     * @param accountNo the account number of the potential
     * administrator
     * </p>
     * <p>
     * @param password the password to authenticate
     * </p>
     * <p>
     * @return a String with the administrator object's id to be kept
     * in the web session
     * </p>
     * @param name 
     * @param accountNo 
     * @param password 
     * @return  String
     * @throws AdminException
     */
    public String authenticateAsAdministrator(String name, String accountNo, String password)
        throws AdminException;

    /**
     * <p>
     * Creates a new administrator. Works only if there is no other
     * administrator object in the system.
     * </p>
     * <p>
     * @param name The display name of the new administrator
     * </p>
     * <p>
     * @param accountNo the account number of the potential
     * administrator
     * </p>
     * <p>
     * @param password the password to authenticate
     * </p>
     * <p>
     * @return a String with the id of the administrator object to be
     * kept in the web session
     * </p>
     * @param name 
     * @param accountNo 
     * @param password 
     * @return  String
     * @throws AdminException
     */
    public String createAdministrator(String name, String accountNo, String password)
        throws AdminException;

}