/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.webservice.metafacades;

import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.andromda.cartridges.webservice.WebServiceUtils;
import org.andromda.cartridges.webservice.metafacades.WebServiceLogic;
import org.andromda.cartridges.webservice.metafacades.WebServiceOperation;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.Introspector;
import org.andromda.core.metafacade.MetafacadeException;
import org.andromda.metafacades.uml.AssociationEndFacade;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.OperationFacade;
import org.andromda.metafacades.uml.ParameterFacade;
import org.andromda.metafacades.uml.ServiceOperation;
import org.andromda.metafacades.uml.UMLProfile;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class WebServiceLogicImpl
extends WebServiceLogic {
    private static final String PROPERTY_DEFAULT_STYLE = "defaultStyle";
    private static final String PROPERTY_DEFAULT_USE = "defaultUse";
    private Collection checkedTypes = new ArrayList();
    static final String NAMESPACE_PREFIX = "namespacePrefix";
    static final String QNAME_LOCAL_PART_PATTERN = "qualifiedNameLocalPartPattern";
    static final String NAMESPACE_PATTERN = "namespacePattern";
    static final String REVERSE_NAMESPACE = "reverseNamespace";
    private static final String RPC_CLASS_NAME_PATTERN = "rpcClassNamePattern";
    private static final String WSDL_OPERATION_SORT_MODE = "wsdlOperationSortMode";
    private static final String OPERATION_SORT_MODE_NAME = "name";
    private static final String OPERATION_SORT_MODE_NONE = "none";
    private static final String TEST_PACKAGE_NAME_PATTERN = "testPackageNamePattern";
    private static final String TEST_NAME_PATTERN = "testNamePattern";
    private static final String STYLE_WRAPPED = "wrapped";
    private static final String STYLE_DOCUMENT = "document";
    private static final String STYLE_RPC = "rpc";
    private static final String USE_LITERAL = "literal";
    private static final String USE_ENCODED = "encoded";
    private static final String TEST_IMPLEMENTATION_NAME_PATTERN = "testImplementationNamePattern";
    static /* synthetic */ Class class$org$andromda$cartridges$webservice$metafacades$WebServiceOperation;
    static /* synthetic */ Class class$org$andromda$metafacades$uml$ServiceOperation;

    public WebServiceLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    protected Collection handleGetAllowedOperations() {
        ArrayList operations = new ArrayList(this.getOperations());
        CollectionUtils.filter(operations, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                boolean valid = (class$org$andromda$cartridges$webservice$metafacades$WebServiceOperation == null ? (class$org$andromda$cartridges$webservice$metafacades$WebServiceOperation = WebServiceLogicImpl.class$("org.andromda.cartridges.webservice.metafacades.WebServiceOperation")) : class$org$andromda$cartridges$webservice$metafacades$WebServiceOperation).isAssignableFrom(object.getClass());
                if (valid) {
                    valid = ((WebServiceOperation)object).isExposed();
                }
                return valid;
            }
        });
        if (this.getWSDLOperationSortMode().equals(OPERATION_SORT_MODE_NAME)) {
            Collections.sort(operations, new OperationNameComparator());
        }
        return operations;
    }

    protected String handleGetAllowedMethods() {
        ArrayList<String> methodNames = new ArrayList<String>();
        Collection operations = this.getAllowedOperations();
        if (operations != null && !operations.isEmpty()) {
            Iterator operationIt = operations.iterator();
            while (operationIt.hasNext()) {
                OperationFacade operation = (OperationFacade)operationIt.next();
                methodNames.add(StringUtils.trimToEmpty((String)operation.getName()));
            }
        }
        return StringUtils.join(methodNames.iterator(), (String)" ");
    }

    protected String handleGetQName() {
        return MessageFormat.format(this.getQualifiedNameLocalPartPattern(), StringUtils.trimToEmpty((String)this.getName()));
    }

    protected String handleGetNamespace() {
        String packageName = this.getPackageName();
        if (this.isReverseNamespace()) {
            packageName = WebServiceUtils.reversePackage(packageName);
        }
        return MessageFormat.format(this.getNamespacePattern(), StringUtils.trimToEmpty((String)packageName));
    }

    protected String handleGetStyle() {
        String style = (String)this.findTaggedValue(UMLProfile.TAGGEDVALUE_WEBSERVICE_STYLE);
        if (StringUtils.isEmpty((String)style)) {
            style = String.valueOf(this.getConfiguredProperty(PROPERTY_DEFAULT_STYLE));
        }
        return style;
    }

    protected String handleGetUse() {
        String use = (String)this.findTaggedValue(UMLProfile.TAGGEDVALUE_WEBSERVICE_USE);
        if (StringUtils.isEmpty((String)use)) {
            use = String.valueOf(this.getConfiguredProperty(PROPERTY_DEFAULT_USE));
        }
        return use;
    }

    protected Collection handleGetTypeMappingElements() {
        LinkedHashSet parameterTypes = new LinkedHashSet();
        Iterator iterator = this.getAllowedOperations().iterator();
        while (iterator.hasNext()) {
            parameterTypes.addAll(((OperationFacade)iterator.next()).getParameters());
        }
        TreeSet types = new TreeSet(new TypeComparator());
        TreeSet nonArrayTypes = new TreeSet(new TypeComparator());
        this.checkedTypes.clear();
        Iterator iterator2 = parameterTypes.iterator();
        while (iterator2.hasNext()) {
            this.loadTypes((ModelElementFacade)iterator2.next(), types, nonArrayTypes);
        }
        ArrayList exceptions = new ArrayList();
        Iterator iterator3 = this.getAllowedOperations().iterator();
        while (iterator3.hasNext()) {
            exceptions.addAll(((OperationFacade)iterator3.next()).getExceptions());
        }
        types.addAll(exceptions);
        types.addAll(nonArrayTypes);
        return types;
    }

    private void loadTypes(ModelElementFacade modelElement, Set types, Collection nonArrayTypes) {
        ExceptionUtils.checkNull((String)"types", (Object)types);
        ExceptionUtils.checkNull((String)"nonArrayTypes", (Object)nonArrayTypes);
        try {
            ClassifierFacade parameterType;
            if (modelElement != null && !this.checkedTypes.contains(modelElement) && (parameterType = this.getType(modelElement)) != null) {
                Collection specializations;
                HashSet<ClassifierFacade> allTypes = new HashSet<ClassifierFacade>();
                allTypes.add(parameterType);
                Collection generalizations = parameterType.getAllGeneralizations();
                if (generalizations != null) {
                    allTypes.addAll(generalizations);
                }
                if ((specializations = parameterType.getAllSpecializations()) != null) {
                    allTypes.addAll(specializations);
                }
                this.checkedTypes.add(modelElement);
                Iterator allTypesIterator = allTypes.iterator();
                while (allTypesIterator.hasNext()) {
                    Collection properties;
                    ClassifierFacade type = (ClassifierFacade)allTypesIterator.next();
                    if (!this.containsManyType(types, modelElement)) {
                        ClassifierFacade nonArrayType = type;
                        boolean arrayType = type.isArrayType();
                        if (arrayType || this.isValidAssociationEnd(modelElement)) {
                            types.add(modelElement);
                            if (arrayType) {
                                type = nonArrayType = type.getNonArray();
                            }
                        }
                        if (nonArrayType != null && (nonArrayType.hasStereotype(UMLProfile.STEREOTYPE_VALUE_OBJECT) || nonArrayType.isEnumeration())) {
                            nonArrayTypes.add(nonArrayType);
                        }
                    }
                    if (type == null || (properties = type.getProperties()) == null || properties.isEmpty()) continue;
                    Iterator iterator = properties.iterator();
                    while (iterator.hasNext()) {
                        ModelElementFacade property = (ModelElementFacade)iterator.next();
                        this.loadTypes(property, types, nonArrayTypes);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            String message = "Error performing loadTypes";
            this.logger.error((Object)"Error performing loadTypes", throwable);
            throw new MetafacadeException("Error performing loadTypes", throwable);
        }
    }

    private boolean containsManyType(Collection types, Object modelElement) {
        ClassifierFacade classifier = null;
        if (modelElement instanceof AssociationEndFacade) {
            AssociationEndFacade end = (AssociationEndFacade)modelElement;
            if (end.isMany()) {
                classifier = ((AssociationEndFacade)modelElement).getType();
            }
        } else if (modelElement instanceof ClassifierFacade) {
            classifier = (ClassifierFacade)modelElement;
        } else if (modelElement instanceof ParameterFacade) {
            classifier = ((ParameterFacade)modelElement).getType();
        }
        if (classifier != null && classifier.isArrayType()) {
            classifier = classifier.getNonArray();
        }
        final ClassifierFacade compareType = classifier;
        boolean containsManyType = false;
        if (compareType != null) {
            containsManyType = CollectionUtils.find((Collection)types, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    boolean valid = false;
                    if (object != null) {
                        Object type = null;
                        if (object instanceof AssociationEndFacade) {
                            AssociationEndFacade end = (AssociationEndFacade)object;
                            if (end.isMany()) {
                                type = ((AssociationEndFacade)object).getType();
                            }
                        } else if (object instanceof ClassifierFacade) {
                            type = (ClassifierFacade)object;
                            type = type.isArrayType() ? type.getNonArray() : null;
                        }
                        if (type != null) {
                            valid = type.equals(compareType);
                        }
                    }
                    return valid;
                }
            }) != null;
        }
        return containsManyType;
    }

    private boolean isValidAssociationEnd(Object modelElement) {
        return modelElement instanceof AssociationEndFacade && ((AssociationEndFacade)modelElement).isMany();
    }

    protected String handleGetProvider() {
        String provider = (String)this.findTaggedValue(UMLProfile.TAGGEDVALUE_WEBSERVICE_PROVIDER);
        if (StringUtils.isEmpty((String)provider)) {
            provider = (String)this.getConfiguredProperty("defaultProvider");
        }
        return provider;
    }

    protected String handleGetWsdlFile() {
        return StringUtils.replace((String)this.getFullyQualifiedName(), (String)String.valueOf(this.getConfiguredProperty("namespaceSeparator")), (String)"/") + ".wsdl";
    }

    protected ClassifierFacade getType(Object modelElement) {
        try {
            Introspector introspector = Introspector.instance();
            ClassifierFacade type = null;
            String typeProperty = "type";
            if (introspector.isReadable(modelElement, typeProperty)) {
                type = (ClassifierFacade)introspector.getProperty(modelElement, typeProperty);
            }
            typeProperty = "returnType";
            if (type == null && introspector.isReadable(modelElement, typeProperty)) {
                type = (ClassifierFacade)introspector.getProperty(modelElement, typeProperty);
            }
            return type;
        }
        catch (Throwable throwable) {
            String errMsg = "Error performing WebServiceLogicImpl.getType";
            this.logger.error((Object)errMsg, throwable);
            throw new MetafacadeException(errMsg, throwable);
        }
    }

    protected String handleGetNamespacePrefix() {
        return (String)this.getConfiguredProperty(NAMESPACE_PREFIX);
    }

    protected String getQualifiedNameLocalPartPattern() {
        return (String)this.getConfiguredProperty(QNAME_LOCAL_PART_PATTERN);
    }

    protected String getNamespacePattern() {
        return (String)this.getConfiguredProperty(NAMESPACE_PATTERN);
    }

    protected boolean isReverseNamespace() {
        return Boolean.valueOf(String.valueOf(this.getConfiguredProperty(REVERSE_NAMESPACE)));
    }

    protected String handleGetEjbJndiName() {
        StringBuffer jndiName = new StringBuffer();
        String jndiNamePrefix = StringUtils.trimToEmpty((String)this.getEjbJndiNamePrefix());
        if (StringUtils.isNotEmpty((String)jndiNamePrefix)) {
            jndiName.append(jndiNamePrefix);
            jndiName.append("/");
        }
        jndiName.append("ejb/");
        jndiName.append(this.getFullyQualifiedName());
        return jndiName.toString();
    }

    protected String getEjbJndiNamePrefix() {
        String property = "ejbJndiNamePrefix";
        return this.isConfiguredProperty("ejbJndiNamePrefix") ? ObjectUtils.toString((Object)this.getConfiguredProperty("ejbJndiNamePrefix")) : null;
    }

    protected String handleGetEjbHomeInterface() {
        return MessageFormat.format(this.getEjbHomeInterfacePattern(), StringUtils.trimToEmpty((String)this.getPackageName()), StringUtils.trimToEmpty((String)this.getName()));
    }

    protected String getEjbHomeInterfacePattern() {
        return (String)this.getConfiguredProperty("ejbHomeInterfacePattern");
    }

    protected String handleGetEjbInterface() {
        return MessageFormat.format(this.getEjbInterfacePattern(), StringUtils.trimToEmpty((String)this.getPackageName()), StringUtils.trimToEmpty((String)this.getName()));
    }

    protected String getEjbInterfacePattern() {
        return (String)this.getConfiguredProperty("ejbInterfacePattern");
    }

    protected String getRpcClassNamePattern() {
        return (String)this.getConfiguredProperty(RPC_CLASS_NAME_PATTERN);
    }

    protected String handleGetRpcClassName() {
        return MessageFormat.format(this.getRpcClassNamePattern(), StringUtils.trimToEmpty((String)this.getPackageName()), StringUtils.trimToEmpty((String)this.getName()));
    }

    private String getWSDLOperationSortMode() {
        Object property = this.getConfiguredProperty(WSDL_OPERATION_SORT_MODE);
        return property != null || property.equals(OPERATION_SORT_MODE_NAME) ? (String)property : OPERATION_SORT_MODE_NONE;
    }

    protected boolean handleIsSecured() {
        Collection roles = this.getAllRoles();
        return roles != null && !roles.isEmpty();
    }

    public Collection getAllRoles() {
        final LinkedHashSet roles = new LinkedHashSet(this.getRoles());
        CollectionUtils.forAllDo((Collection)this.getAllowedOperations(), (Closure)new Closure(){

            public void execute(Object object) {
                if (object != null && (class$org$andromda$metafacades$uml$ServiceOperation == null ? (class$org$andromda$metafacades$uml$ServiceOperation = WebServiceLogicImpl.class$("org.andromda.metafacades.uml.ServiceOperation")) : class$org$andromda$metafacades$uml$ServiceOperation).isAssignableFrom(object.getClass())) {
                    roles.addAll(((ServiceOperation)object).getRoles());
                }
            }
        });
        return roles;
    }

    protected String handleGetTestPackageName() {
        return String.valueOf(this.getConfiguredProperty(TEST_PACKAGE_NAME_PATTERN)).replaceAll("\\{0\\}", this.getPackageName());
    }

    protected String handleGetFullyQualifiedTestName() {
        return this.getTestPackageName() + '.' + this.getTestName();
    }

    protected String handleGetTestName() {
        return String.valueOf(this.getConfiguredProperty(TEST_NAME_PATTERN)).replaceAll("\\{0\\}", this.getName());
    }

    protected boolean handleIsWrappedStyle() {
        return this.getStyle().equalsIgnoreCase(STYLE_WRAPPED);
    }

    protected boolean handleIsDocumentStyle() {
        return this.getStyle().equalsIgnoreCase(STYLE_DOCUMENT);
    }

    protected boolean handleIsRpcStyle() {
        return this.getStyle().equalsIgnoreCase(STYLE_RPC);
    }

    protected boolean handleIsLiteralUse() {
        return this.getStyle().equalsIgnoreCase(USE_LITERAL);
    }

    protected boolean handleIsEncodedUse() {
        return this.getStyle().equalsIgnoreCase(USE_ENCODED);
    }

    protected String handleGetTestImplementationName() {
        return String.valueOf(this.getConfiguredProperty(TEST_IMPLEMENTATION_NAME_PATTERN)).replaceAll("\\{0\\}", this.getName());
    }

    protected String handleGetFullyQualifiedTestImplementationName() {
        return this.getTestPackageName() + '.' + this.getTestImplementationName();
    }

    private static final class OperationNameComparator
    implements Comparator {
        private final Collator collator = Collator.getInstance();

        private OperationNameComparator() {
            this.collator.setStrength(0);
        }

        public int compare(Object objectA, Object objectB) {
            ModelElementFacade a = (ModelElementFacade)objectA;
            ModelElementFacade b = (ModelElementFacade)objectB;
            return this.collator.compare(a.getName(), b.getName());
        }
    }

    private final class TypeComparator
    implements Comparator {
        private final Collator collator = Collator.getInstance();

        private TypeComparator() {
            this.collator.setStrength(0);
        }

        public int compare(Object objectA, Object objectB) {
            ModelElementFacade b;
            ClassifierFacade bType;
            ModelElementFacade a = (ModelElementFacade)objectA;
            ClassifierFacade aType = WebServiceLogicImpl.this.getType(a);
            if (aType == null) {
                aType = a;
            }
            if ((bType = WebServiceLogicImpl.this.getType(b = (ModelElementFacade)objectB)) == null) {
                bType = b;
            }
            return this.collator.compare(aType.getFullyQualifiedName(), bType.getFullyQualifiedName());
        }
    }
}

