/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.webservice.metafacades;

import org.andromda.cartridges.webservice.WebServiceUtils;
import org.andromda.cartridges.webservice.metafacades.WSDLTypeLogic;
import org.andromda.metafacades.uml.TypeMappings;
import org.apache.commons.lang.StringUtils;

public class WSDLTypeLogicImpl
extends WSDLTypeLogic {
    public WSDLTypeLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    public String handleGetSchemaType() {
        return this.getSchemaType(true, true);
    }

    public String handleGetSchemaType(boolean withPrefix, boolean preserveArray) {
        return WebServiceUtils.getSchemaType(this, this.getSchemaTypeMappings(), this.getNamespacePrefix(), this.getQName(), this.getWsdlArrayNamePrefix(), withPrefix, preserveArray);
    }

    protected String handleGetWsdlArrayName() {
        StringBuffer name = new StringBuffer(StringUtils.trimToEmpty((String)this.getQName()).replaceAll("\\[\\]", ""));
        name.insert(0, this.getWsdlArrayNamePrefix());
        return name.toString();
    }

    protected String handleGetWsdlArrayNamePrefix() {
        return String.valueOf(this.getConfiguredProperty("arrayNamePrefix"));
    }

    protected String handleGetQName() {
        return this.getQualfiedNameLocalPartPattern().replaceAll("\\{0\\}", StringUtils.trimToEmpty((String)this.getName()));
    }

    protected String handleGetNamespace() {
        String packageName = this.getPackageName();
        if (this.isReverseNamespace()) {
            packageName = WebServiceUtils.reversePackage(packageName);
        }
        return this.getNamespacePattern().replaceAll("\\{0\\}", StringUtils.trimToEmpty((String)packageName));
    }

    private String getArraySuffix() {
        return String.valueOf(this.getConfiguredProperty("arrayNameSuffix"));
    }

    private TypeMappings getSchemaTypeMappings() {
        String propertyName = "schemaTypeMappingsUri";
        Object property = this.getConfiguredProperty("schemaTypeMappingsUri");
        TypeMappings mappings = null;
        String uri = null;
        if (property instanceof String) {
            uri = (String)property;
            try {
                mappings = TypeMappings.getInstance((String)uri);
                mappings.setArraySuffix(this.getArraySuffix());
                this.setProperty("schemaTypeMappingsUri", mappings);
            }
            catch (Throwable th) {
                String errMsg = "Error getting 'schemaTypeMappingsUri' --> '" + uri + "'";
                this.logger.error((Object)errMsg, th);
            }
        } else {
            mappings = (TypeMappings)property;
        }
        return mappings;
    }

    protected String handleGetNamespacePrefix() {
        return (String)this.getConfiguredProperty("namespacePrefix");
    }

    protected String getQualfiedNameLocalPartPattern() {
        return (String)this.getConfiguredProperty("qualifiedNameLocalPartPattern");
    }

    protected String getNamespacePattern() {
        return (String)this.getConfiguredProperty("namespacePattern");
    }

    private boolean isReverseNamespace() {
        return Boolean.valueOf(String.valueOf(this.getConfiguredProperty("reverseNamespace")));
    }
}

