/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.spring.metafacades;

import org.andromda.cartridges.spring.SpringProfile;
import org.andromda.cartridges.spring.metafacades.SpringServiceOperationLogic;
import org.andromda.metafacades.uml.UMLProfile;
import org.apache.commons.lang.StringUtils;

public class SpringServiceOperationLogicImpl
extends SpringServiceOperationLogic {
    private static final String SERVICE_OPERATION_TRANSACTION_TYPE = "serviceOperationTransactionType";
    private static final String EJB_SERVICE_OPERATION_TRANSACTION_TYPE = "ejbServiceOperationTransactionType";

    public SpringServiceOperationLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    protected boolean handleIsWebserviceExposed() {
        return this.hasStereotype(UMLProfile.STEREOTYPE_WEBSERVICE_OPERATION);
    }

    protected String handleGetImplementationName() {
        return this.getImplementationOperationName(StringUtils.capitalize((String)this.getName()));
    }

    protected String handleGetImplementationSignature() {
        return this.getImplementationOperationName(StringUtils.capitalize((String)this.getSignature()));
    }

    protected String handleGetImplementationCall() {
        return this.getImplementationOperationName(StringUtils.capitalize((String)this.getCall()));
    }

    private String getImplementationOperationName(String replacement) {
        return StringUtils.trimToEmpty((String)String.valueOf(this.getConfiguredProperty("implementationOperationNamePattern"))).replaceAll("\\{0\\}", replacement);
    }

    public String handleGetTransactionType() {
        String transactionType = (String)this.findTaggedValue(SpringProfile.TAGGEDVALUE_TRANSACTION_TYPE);
        if (StringUtils.isBlank((String)transactionType)) {
            transactionType = (String)this.getOwner().findTaggedValue(SpringProfile.TAGGEDVALUE_TRANSACTION_TYPE);
        }
        if (StringUtils.isBlank((String)transactionType)) {
            transactionType = String.valueOf(this.getConfiguredProperty(SERVICE_OPERATION_TRANSACTION_TYPE));
        }
        return transactionType;
    }

    protected String handleGetEjbTransactionType() {
        String transactionType = (String)this.findTaggedValue(SpringProfile.TAGGEDVALUE_EJB_TRANSACTION_TYPE);
        if (StringUtils.isBlank((String)transactionType)) {
            transactionType = (String)this.getOwner().findTaggedValue(SpringProfile.TAGGEDVALUE_EJB_TRANSACTION_TYPE);
        }
        if (StringUtils.isBlank((String)transactionType)) {
            transactionType = String.valueOf(this.getConfiguredProperty(EJB_SERVICE_OPERATION_TRANSACTION_TYPE));
        }
        return transactionType;
    }

    protected String handleGetThrowsClause() {
        StringBuffer throwsClause = null;
        if (this.isExceptionsPresent()) {
            throwsClause = new StringBuffer(this.getExceptionList());
        }
        if (throwsClause != null) {
            throwsClause.insert(0, "throws ");
        }
        return throwsClause != null ? throwsClause.toString() : null;
    }

    protected String handleGetThrowsClause(String initialExceptions) {
        StringBuffer throwsClause = new StringBuffer(initialExceptions);
        if (this.getThrowsClause() != null) {
            throwsClause.insert(0, ", ");
            throwsClause.insert(0, this.getThrowsClause());
        } else {
            throwsClause.insert(0, "throws ");
        }
        return throwsClause.toString();
    }
}

