/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.spring.metafacades;

import java.text.MessageFormat;
import java.util.Collection;
import org.andromda.cartridges.spring.SpringProfile;
import org.andromda.cartridges.spring.metafacades.SpringMetafacadeUtils;
import org.andromda.cartridges.spring.metafacades.SpringServiceLogic;
import org.andromda.cartridges.spring.metafacades.SpringServiceOperation;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.FilteredCollection;
import org.andromda.metafacades.uml.OperationFacade;
import org.andromda.metafacades.uml.UMLProfile;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class SpringServiceLogicImpl
extends SpringServiceLogic {
    private static final String HIBERNATE_INTERCEPTOR_ENABLED = "serviceHibernateInterceptorEnabled";
    private static final String EJB_VIEW_TYPE = "ejbViewType";
    private static final String EJB_REMOTE_VIEW = "remote";
    private static final String EJB_LOCAL_VIEW = "local";
    private static final String EJB_BOTH_VIEW = "both";

    public SpringServiceLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    protected String handleGetEjbJndiName() {
        StringBuffer jndiName = new StringBuffer();
        String jndiNamePrefix = StringUtils.trimToEmpty((String)this.getEjbJndiNamePrefix());
        if (StringUtils.isNotEmpty((String)jndiNamePrefix)) {
            jndiName.append(jndiNamePrefix);
            jndiName.append("/");
        }
        jndiName.append("ejb/");
        jndiName.append(this.getFullyQualifiedName());
        return jndiName.toString();
    }

    protected String handleGetEjbLocalJndiName() {
        StringBuffer jndiName = new StringBuffer();
        String jndiNamePrefix = StringUtils.trimToEmpty((String)this.getEjbJndiNamePrefix());
        if (StringUtils.isNotEmpty((String)jndiNamePrefix)) {
            jndiName.append(jndiNamePrefix);
            jndiName.append("/");
        }
        jndiName.append("ejb/");
        jndiName.append(SpringMetafacadeUtils.getFullyQualifiedName(this.getPackageName(), this.getName(), this.getEjbViewType().equalsIgnoreCase(EJB_BOTH_VIEW) ? "Local" : null));
        return jndiName.toString();
    }

    protected String handleGetEjbImplementationName() {
        return this.getName() + "Bean";
    }

    protected String handleGetImplementationName() {
        return this.getName() + "Impl";
    }

    protected String handleGetFullyQualifiedEjbImplementationName() {
        return SpringMetafacadeUtils.getFullyQualifiedName(this.getEjbPackageName(), this.getName(), "Bean");
    }

    protected String handleGetFullyQualifiedEjbName() {
        return SpringMetafacadeUtils.getFullyQualifiedName(this.getEjbPackageName(), this.getName(), null);
    }

    protected String handleGetFullyQualifiedLocalEjbName() {
        return SpringMetafacadeUtils.getFullyQualifiedName(this.getEjbPackageName(), this.getName(), this.getEjbViewType().equalsIgnoreCase(EJB_BOTH_VIEW) ? "Local" : null);
    }

    protected String handleGetFullyQualifiedImplementationName() {
        return SpringMetafacadeUtils.getFullyQualifiedName(this.getPackageName(), this.getName(), "Impl");
    }

    protected String handleGetBaseName() {
        return this.getName() + "Base";
    }

    protected String handleGetFullyQualifiedBaseName() {
        return SpringMetafacadeUtils.getFullyQualifiedName(this.getPackageName(), this.getName(), "Base");
    }

    protected String handleGetEjbPackageName() {
        String ejbPackageName = MessageFormat.format(this.getEjbPackageNamePattern(), StringUtils.trimToEmpty((String)this.getPackageName()));
        if (StringUtils.isBlank((String)this.getPackageName())) {
            ejbPackageName = ejbPackageName.replaceAll("^\\.", "");
        }
        return ejbPackageName;
    }

    protected String handleGetEjbPackageNamePath() {
        return this.getEjbPackageName().replace('.', '/');
    }

    protected String handleGetBeanName() {
        return this.getBeanName(false);
    }

    protected String handleGetBeanName(boolean targetSuffix) {
        StringBuffer beanName = new StringBuffer(StringUtils.uncapitalize((String)StringUtils.trimToEmpty((String)this.getName())));
        if (targetSuffix) {
            beanName.append("Target");
        }
        return beanName.toString();
    }

    protected String getEjbPackageNamePattern() {
        return (String)this.getConfiguredProperty("ejbPackageNamePattern");
    }

    protected String getEjbJndiNamePrefix() {
        return this.isConfiguredProperty("ejbJndiNamePrefix") ? ObjectUtils.toString((Object)this.getConfiguredProperty("ejbJndiNamePrefix")) : null;
    }

    protected String handleGetWebServiceDelegatorName() {
        return this.getName() + "WSDelegator";
    }

    protected String handleGetFullyQualifiedWebServiceDelegatorName() {
        return this.getFullyQualifiedName() + "WSDelegator";
    }

    protected boolean handleIsWebService() {
        boolean webService = this.hasStereotype(UMLProfile.STEREOTYPE_WEBSERVICE);
        if (!webService) {
            webService = !this.getWebServiceOperations().isEmpty();
        }
        return webService;
    }

    protected String[] handleGetInterceptors() {
        String serviceInterceptorString = this.isConfiguredProperty("serviceInterceptors") ? ObjectUtils.toString((Object)this.getConfiguredProperty("serviceInterceptors")) : null;
        String[] interceptors = null;
        if (StringUtils.isNotEmpty((String)serviceInterceptorString)) {
            interceptors = serviceInterceptorString.split(",");
        }
        return SpringMetafacadeUtils.getServiceInterceptors((ClassifierFacade)this, interceptors);
    }

    protected boolean handleIsRemotable() {
        return !this.isRemotingTypeNone();
    }

    private String getRemotingType() {
        String serviceRemotingType = StringUtils.trimToEmpty((String)String.valueOf(this.getConfiguredProperty("serviceRemotingType")));
        return SpringMetafacadeUtils.getServiceRemotingType((ClassifierFacade)this, serviceRemotingType);
    }

    protected String handleGetRemoteServer() {
        return StringUtils.trimToEmpty((String)String.valueOf(this.getConfiguredProperty("serviceRemoteServer")));
    }

    protected String handleGetRemotePort() {
        String serviceRemotePort = StringUtils.trimToEmpty((String)String.valueOf(this.getConfiguredProperty("serviceRemotePort")));
        return SpringMetafacadeUtils.getServiceRemotePort((ClassifierFacade)this, serviceRemotePort);
    }

    protected String handleGetRemoteContext() {
        return this.isConfiguredProperty("serviceRemoteContext") ? ObjectUtils.toString((Object)this.getConfiguredProperty("serviceRemoteContext")) : "";
    }

    private boolean hasServiceRemotePort() {
        String serviceRemotePort = this.getRemotePort();
        return StringUtils.isNotEmpty((String)serviceRemotePort);
    }

    private boolean hasServiceRemoteContext() {
        String serviceRemoteContext = this.getRemoteContext();
        return StringUtils.isNotEmpty((String)serviceRemoteContext);
    }

    protected String handleGetRemoteUrl() {
        String result = "";
        String propertyPrefix = ObjectUtils.toString((Object)this.getConfiguredProperty("configPropertyPrefix"));
        if (!this.isRemotingTypeNone()) {
            if (this.isRemotingTypeHttpInvoker() || this.isRemotingTypeHessian() || this.isRemotingTypeBurlap()) {
                result = "http://${" + propertyPrefix + "remoteServer}";
                if (this.hasServiceRemotePort()) {
                    result = result + ":${" + propertyPrefix + "remotePort}";
                }
                if (this.hasServiceRemoteContext()) {
                    result = result + "/${" + propertyPrefix + "remoteContext}";
                }
                result = result + "/" + this.getName();
            } else if (this.isRemotingTypeRmi()) {
                result = "rmi://${" + propertyPrefix + "remoteServer}";
                if (this.hasServiceRemotePort()) {
                    result = result + ":${" + propertyPrefix + "remotePort}";
                }
                result = result + "/" + this.getName();
            }
        }
        return result;
    }

    protected Collection handleGetWebServiceOperations() {
        Collection operations = this.getOperations();
        if (!this.hasStereotype(UMLProfile.STEREOTYPE_WEBSERVICE)) {
            operations = new FilteredCollection(operations){

                public boolean evaluate(Object object) {
                    return object instanceof SpringServiceOperation && ((SpringServiceOperation)object).isWebserviceExposed();
                }
            };
        }
        return operations;
    }

    public Collection getOperations() {
        final Collection operations = super.getOperations();
        if (!this.isAbstract()) {
            for (ClassifierFacade generalization = (ClassifierFacade)this.getGeneralization(); generalization != null; generalization = (ClassifierFacade)generalization.getGeneralization()) {
                if (!generalization.isAbstract()) continue;
                CollectionUtils.forAllDo((Collection)generalization.getOperations(), (Closure)new Closure(){

                    public void execute(Object object) {
                        if (((OperationFacade)object).isAbstract()) {
                            operations.add(object);
                        }
                    }
                });
            }
        }
        return operations;
    }

    protected String handleGetDefaultExceptionName() {
        String name = StringUtils.trimToEmpty((String)String.valueOf(this.getConfiguredProperty("defaultServiceExceptionNamePattern")));
        return name.replaceAll("\\{0\\}", this.getName());
    }

    protected String handleGetFullyQualifiedDefaultExceptionName() {
        StringBuffer fullyQualifiedName = new StringBuffer("java.lang.RuntimeException");
        if (this.isAllowDefaultServiceException()) {
            fullyQualifiedName = new StringBuffer();
            if (StringUtils.isNotBlank((String)this.getPackageName())) {
                fullyQualifiedName.append(this.getPackageName());
                fullyQualifiedName.append('.');
            }
            fullyQualifiedName.append(this.getDefaultExceptionName());
        }
        return fullyQualifiedName.toString();
    }

    protected boolean handleIsAllowDefaultServiceException() {
        return Boolean.valueOf(String.valueOf(this.getConfiguredProperty("defaultServiceExceptions")));
    }

    protected boolean handleIsRemotingTypeRmi() {
        return this.getRemotingType().equalsIgnoreCase("rmi");
    }

    protected boolean handleIsRemotingTypeBurlap() {
        return this.getRemotingType().equalsIgnoreCase("burlap");
    }

    protected boolean handleIsRemotingTypeHessian() {
        return this.getRemotingType().equalsIgnoreCase("hessian");
    }

    protected boolean handleIsRemotingTypeHttpInvoker() {
        return this.getRemotingType().equalsIgnoreCase("httpinvoker");
    }

    protected boolean handleIsRemotingTypeNone() {
        return this.getRemotingType().equalsIgnoreCase("none");
    }

    protected boolean handleIsHibernateInterceptorEnabled() {
        return Boolean.valueOf(String.valueOf(this.getConfiguredProperty(HIBERNATE_INTERCEPTOR_ENABLED)));
    }

    private String getEjbViewType() {
        Object value = this.findTaggedValue(SpringProfile.TAGGEDVALUE_EJB_VIEW_TYPE);
        if (value == null) {
            value = this.getConfiguredProperty(EJB_VIEW_TYPE);
        }
        return ObjectUtils.toString((Object)value);
    }

    protected boolean handleIsEjbRemoteView() {
        return this.getEjbViewType().equalsIgnoreCase(EJB_REMOTE_VIEW) || this.getEjbViewType().equalsIgnoreCase(EJB_BOTH_VIEW);
    }

    protected boolean handleIsEjbLocalView() {
        return this.getEjbViewType().equalsIgnoreCase(EJB_LOCAL_VIEW) || this.getEjbViewType().equalsIgnoreCase(EJB_BOTH_VIEW);
    }

    protected String handleGetEjbTransactionType() {
        boolean ejbTransactionsEnabled = BooleanUtils.toBoolean((String)ObjectUtils.toString((Object)this.getConfiguredProperty("ejbTransactionsEnabled")));
        String transactionType = ejbTransactionsEnabled ? "Container" : "Bean";
        return transactionType;
    }

    protected boolean handleIsConfigonly() {
        String value = (String)this.findTaggedValue(SpringProfile.TAGGEDVALUE_SERVICE_CONFIG_ONLY);
        return BooleanUtils.toBoolean((String)StringUtils.trimToEmpty((String)value));
    }

    protected String handleGetWebServiceOutgoingAttachmentHandlerCall() {
        return this.getWebServiceAttachmentHandlerCall("webServiceOutgoingAttachmentHandlerCallPattern");
    }

    protected String handleGetWebServiceIncomingAttachmentHandlerCall() {
        return this.getWebServiceAttachmentHandlerCall("webServiceIncomingAttachmentHandlerCallPattern");
    }

    private String getWebServiceAttachmentHandlerCall(String patternProperty) {
        String value;
        String call = null;
        if (this.isWebService() && StringUtils.isNotBlank((String)(value = ObjectUtils.toString((Object)this.getConfiguredProperty(patternProperty))))) {
            call = value;
        }
        return call;
    }

    protected boolean handleIsRichClient() {
        String richClient = StringUtils.trimToEmpty((String)String.valueOf(this.getConfiguredProperty("richClient")));
        return richClient.equalsIgnoreCase("true");
    }
}

