/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.spring.metafacades;

import java.util.Collection;
import java.util.Iterator;
import org.andromda.cartridges.spring.SpringProfile;
import org.andromda.cartridges.spring.metafacades.SpringEntity;
import org.andromda.cartridges.spring.metafacades.SpringMetafacadeUtils;
import org.andromda.cartridges.spring.metafacades.SpringQueryOperationLogic;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.OperationFacade;
import org.andromda.metafacades.uml.ParameterFacade;
import org.andromda.metafacades.uml.UMLProfile;
import org.apache.commons.lang.StringUtils;

public class SpringQueryOperationLogicImpl
extends SpringQueryOperationLogic {
    private String translatedQuery = null;
    private static final String USE_NAMED_PARAMETERS = "hibernateQueryUseNamedParameters";

    public SpringQueryOperationLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    protected String handleGetQuery() {
        return this.getQuery((SpringEntity)null);
    }

    private String getTranslatedQuery() {
        if (this.translatedQuery == null) {
            this.translatedQuery = super.getQuery("query.Hibernate-QL");
        }
        return this.translatedQuery;
    }

    protected boolean handleIsUseNamedParameters() {
        boolean useNamedParameters = Boolean.valueOf(String.valueOf(this.getConfiguredProperty(USE_NAMED_PARAMETERS))) != false || StringUtils.isNotBlank((String)this.getTranslatedQuery());
        return SpringMetafacadeUtils.getUseNamedParameters((OperationFacade)this, useNamedParameters);
    }

    protected boolean handleIsCriteriaFinder() {
        return this.getCriteriaArgument() != null;
    }

    protected ParameterFacade handleGetCriteriaArgument() {
        ParameterFacade foundParameter = null;
        Iterator iterator = this.getParameters().iterator();
        while (iterator.hasNext()) {
            ParameterFacade parameter = (ParameterFacade)iterator.next();
            ClassifierFacade type = parameter.getType();
            if (type == null || !type.hasStereotype(UMLProfile.STEREOTYPE_CRITERIA)) continue;
            foundParameter = parameter;
            break;
        }
        return foundParameter;
    }

    protected String handleGetQuery(SpringEntity entity) {
        Object value;
        String queryString = this.getTranslatedQuery();
        if (StringUtils.isEmpty((String)queryString) && (queryString = (String)(value = this.findTaggedValue(SpringProfile.TAGGEDVALUE_HIBERNATE_QUERY))) != null) {
            queryString = queryString.replaceAll("[$\\s]+", " ");
        }
        if (StringUtils.isEmpty((String)queryString)) {
            SpringEntity owner = entity == null ? this.getOwner() : entity;
            String variableName = StringUtils.uncapitalize((String)owner.getName());
            queryString = "from " + owner.getFullyQualifiedName() + " as " + variableName;
            if (this.getArguments().size() > 0) {
                queryString = queryString + " where";
                Collection arguments = this.getArguments();
                if (arguments != null && !arguments.isEmpty()) {
                    Iterator argumentIt = arguments.iterator();
                    int ctr = 0;
                    while (argumentIt.hasNext()) {
                        ParameterFacade argument = (ParameterFacade)argumentIt.next();
                        String parameter = "?";
                        if (this.isUseNamedParameters()) {
                            parameter = ":" + argument.getName();
                        }
                        queryString = queryString + " " + variableName + "." + argument.getName() + " = " + parameter;
                        if (argumentIt.hasNext()) {
                            queryString = queryString + " and";
                        }
                        ++ctr;
                    }
                }
            }
        }
        return queryString;
    }
}

