/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.spring.metafacades;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.andromda.cartridges.spring.SpringHibernateUtils;
import org.andromda.cartridges.spring.metafacades.SpringDependencyLogic;
import org.andromda.cartridges.spring.metafacades.SpringEntity;
import org.andromda.metafacades.uml.DependencyFacade;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;

public class SpringDependencyLogicImpl
extends SpringDependencyLogic {
    private static final String TRANSFORMATION_ANONYMOUS_NAME_SUFFIX = "_TRANSFORMER";
    private static final String TRANSFORMATION_TO_ENTITY_METHOD_NAME_SUFFIX = "ToEntity";
    private static final String VALUE_OBJECT_TO_ENTITY_TRANSFORMER_SUFFIX = "Transformer";

    public SpringDependencyLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    protected String handleGetTransformationConstantName() {
        return "TRANSFORM_" + this.getName().toUpperCase();
    }

    protected String handleGetTransformationMethodName() {
        return "to" + StringUtils.capitalize((String)this.getName());
    }

    protected String handleGetTransformationAnonymousName() {
        return this.getName().toUpperCase() + TRANSFORMATION_ANONYMOUS_NAME_SUFFIX;
    }

    protected boolean handleIsCircularReference() {
        boolean circularReference = false;
        final ModelElementFacade sourceElement = this.getSourceElement();
        ModelElementFacade targetElement = this.getTargetElement();
        Collection sourceDependencies = targetElement.getSourceDependencies();
        if (sourceDependencies != null && !sourceDependencies.isEmpty()) {
            circularReference = CollectionUtils.find((Collection)sourceDependencies, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    DependencyFacade dependency = (DependencyFacade)object;
                    return dependency != null && dependency.getTargetElement().equals(sourceElement);
                }
            }) != null;
        }
        return circularReference;
    }

    private boolean isXmlPersistenceActive() {
        return SpringHibernateUtils.isXmlPersistenceActive((String)this.getConfiguredProperty("hibernateVersion"), (String)this.getConfiguredProperty("hibernateXMLPersistence"));
    }

    protected int handleGetTransformationConstantValue() {
        int value = 0;
        ModelElementFacade element = this.getSourceElement();
        if (element instanceof SpringEntity) {
            ArrayList<SpringEntity> hierarchy = new ArrayList<SpringEntity>();
            for (SpringEntity entity = (SpringEntity)element; entity != null; entity = (SpringEntity)entity.getGeneralization()) {
                hierarchy.add(entity);
            }
            boolean breakOut = false;
            for (int ctr = hierarchy.size() - 1; ctr >= 0; --ctr) {
                SpringEntity generalization = (SpringEntity)hierarchy.get(ctr);
                Iterator referenceIterator = generalization.getValueObjectReferences().iterator();
                while (referenceIterator.hasNext()) {
                    Object reference = referenceIterator.next();
                    ++value;
                    if (!reference.equals(this)) continue;
                    breakOut = true;
                    break;
                }
                if (breakOut) break;
            }
        }
        if (this.isXmlPersistenceActive()) {
            ++value;
        }
        return value;
    }

    protected String handleGetTransformationToCollectionMethodName() {
        return "to" + StringUtils.capitalize((String)this.getName()) + "Collection";
    }

    protected String handleGetDaoName() {
        return this.getDaoNamePattern().replaceAll("\\{0\\}", this.getName());
    }

    private String getDaoNamePattern() {
        return String.valueOf(this.getConfiguredProperty("daoNamePattern"));
    }

    protected String handleGetDaoGetterName() {
        return "get" + StringUtils.capitalize((String)this.getDaoName());
    }

    protected String handleGetDaoSetterName() {
        return "set" + StringUtils.capitalize((String)this.getDaoName());
    }

    protected String handleGetTransformationToEntityCollectionMethodName() {
        return this.getTransformationToEntityMethodName() + "Collection";
    }

    protected String handleGetTransformationToEntityMethodName() {
        return this.getName() + TRANSFORMATION_TO_ENTITY_METHOD_NAME_SUFFIX;
    }

    protected String handleGetValueObjectToEntityTransformerName() {
        return StringUtils.capitalize((String)this.getTransformationToEntityMethodName()) + VALUE_OBJECT_TO_ENTITY_TRANSFORMER_SUFFIX;
    }
}

