/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.nhibernate.metafacades;

import org.andromda.cartridges.nhibernate.metafacades.HibernateTypeLogic;
import org.andromda.core.common.ExceptionRecorder;
import org.andromda.metafacades.uml.TypeMappings;
import org.apache.commons.lang.StringUtils;

public class HibernateTypeLogicImpl
extends HibernateTypeLogic {
    public HibernateTypeLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    protected String handleGetFullyQualifiedHibernateType() {
        String fullyQualifiedName = super.getFullyQualifiedName();
        TypeMappings mappings = this.getHibernateTypeMappings();
        if (mappings != null) {
            String fullyQualifiedModelName = super.getFullyQualifiedName(true);
            if (mappings.getMappings().containsFrom(fullyQualifiedModelName)) {
                fullyQualifiedName = mappings.getTo(fullyQualifiedModelName);
            }
        }
        return fullyQualifiedName;
    }

    protected TypeMappings getHibernateTypeMappings() {
        TypeMappings mappings = null;
        String propertyName = "hibernateTypeMappingsUri";
        if (this.isConfiguredProperty("hibernateTypeMappingsUri")) {
            Object property = this.getConfiguredProperty("hibernateTypeMappingsUri");
            String uri = null;
            if (property instanceof String) {
                uri = (String)property;
                if (StringUtils.isNotBlank((String)uri)) {
                    try {
                        mappings = TypeMappings.getInstance((String)((String)property));
                        this.setProperty("hibernateTypeMappingsUri", mappings);
                    }
                    catch (Throwable throwable) {
                        String message = "Error getting 'hibernateTypeMappingsUri' --> '" + uri + "'";
                        this.logger.error((Object)message);
                        ExceptionRecorder.instance().record(message, throwable);
                    }
                }
            } else {
                mappings = (TypeMappings)property;
            }
        }
        return mappings;
    }

    public String getJavaNullString() {
        if (this.getFullyQualifiedName().equals("System.Guid")) {
            return "00000000-0000-0000-0000-000000000000";
        }
        return super.getJavaNullString();
    }
}

