/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.nhibernate.metafacades;

import java.util.Collection;
import java.util.Iterator;
import org.andromda.cartridges.nhibernate.HibernateProfile;
import org.andromda.cartridges.nhibernate.metafacades.HibernateFinderMethodLogic;
import org.andromda.metafacades.uml.ParameterFacade;
import org.apache.commons.lang.StringUtils;

public class HibernateFinderMethodLogicImpl
extends HibernateFinderMethodLogic {
    private String translatedQuery = null;
    private static final String USE_NAMED_PARAMETERS = "hibernateQueryUseNamedParameters";
    private static final String HIBERNATE_USE_QUERY_CACHE = "hibernateUseQueryCache";

    public HibernateFinderMethodLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    protected String handleGetQuery() {
        Object value;
        String queryString = this.getTranslatedQuery();
        if (StringUtils.isEmpty((String)queryString) && (queryString = (String)(value = this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_QUERY))) != null) {
            queryString = queryString.replaceAll("[$\\s]+", " ");
        }
        if (StringUtils.isEmpty((String)queryString)) {
            String variableName = StringUtils.uncapitalize((String)this.getOwner().getName());
            queryString = "from " + this.getOwner().getFullyQualifiedName() + " as " + variableName;
            if (this.getArguments().size() > 0) {
                queryString = queryString + " where";
                Collection arguments = this.getArguments();
                if (arguments != null && !arguments.isEmpty()) {
                    Iterator argumentIt = arguments.iterator();
                    int ctr = 0;
                    while (argumentIt.hasNext()) {
                        ParameterFacade argument = (ParameterFacade)argumentIt.next();
                        String parameter = "?";
                        if (this.isUseNamedParameters()) {
                            parameter = ":" + argument.getName();
                        }
                        queryString = queryString + " " + variableName + "." + argument.getName() + " = " + parameter;
                        if (argumentIt.hasNext()) {
                            queryString = queryString + " and";
                        }
                        ++ctr;
                    }
                }
            }
        }
        return queryString;
    }

    private String getTranslatedQuery() {
        if (this.translatedQuery == null) {
            this.translatedQuery = super.getQuery("query.Hibernate-QL");
        }
        return this.translatedQuery;
    }

    protected boolean handleIsUseNamedParameters() {
        return Boolean.valueOf(String.valueOf(this.getConfiguredProperty(USE_NAMED_PARAMETERS))) != false || StringUtils.isNotBlank((String)this.getTranslatedQuery());
    }

    protected boolean handleIsUseQueryCache() {
        boolean useQueryCache = Boolean.valueOf(String.valueOf(this.getConfiguredProperty(HIBERNATE_USE_QUERY_CACHE)));
        if (useQueryCache) {
            useQueryCache = Boolean.valueOf(String.valueOf(this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_USE_QUERY_CACHE)));
        }
        return useQueryCache;
    }
}

