/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.nhibernate.metafacades;

import java.util.Collection;
import org.andromda.cartridges.nhibernate.HibernateProfile;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.FilteredCollection;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.OperationFacade;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;

class HibernateMetafacadeUtils {
    HibernateMetafacadeUtils() {
    }

    static String getViewType(ClassifierFacade classifier, String defaultViewType) {
        String methodName = "HibernateMetafacadeUtils.getViewType";
        ExceptionUtils.checkNull((String)"HibernateMetafacadeUtils.getViewType", (String)"classifer", (Object)classifier);
        String viewType = null;
        if (classifier.hasStereotype(HibernateProfile.STEREOTYPE_SERVICE)) {
            String viewTypeValue = (String)classifier.findTaggedValue(HibernateProfile.TAGGEDVALUE_EJB_VIEWTYPE);
            if (StringUtils.isEmpty((String)viewTypeValue)) {
                viewType = (String)CollectionUtils.find((Collection)classifier.getAllGeneralizations(), (Predicate)new Predicate(){

                    public boolean evaluate(Object object) {
                        return ((ModelElementFacade)object).findTaggedValue(HibernateProfile.TAGGEDVALUE_EJB_VIEWTYPE) != null;
                    }
                });
            }
            if (StringUtils.isNotEmpty((String)viewTypeValue)) {
                viewType = viewTypeValue;
            }
        }
        if (StringUtils.isEmpty(viewType)) {
            viewType = defaultViewType;
        }
        return viewType.toLowerCase();
    }

    static String getFullyQualifiedName(String packageName, String name, String suffix) {
        StringBuffer fullyQualifiedName = new StringBuffer(StringUtils.trimToEmpty((String)packageName));
        if (StringUtils.isNotBlank((String)packageName)) {
            fullyQualifiedName.append('.');
        }
        fullyQualifiedName.append(StringUtils.trimToEmpty((String)name));
        fullyQualifiedName.append(StringUtils.trimToEmpty((String)suffix));
        return fullyQualifiedName.toString();
    }

    static Collection filterBusinessOperations(Collection operations) {
        FilteredCollection businessOperations = new FilteredCollection(operations){

            public boolean evaluate(Object object) {
                return !((OperationFacade)object).isStatic();
            }
        };
        return businessOperations;
    }
}

