/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.nhibernate.metafacades;

import org.andromda.cartridges.nhibernate.HibernateProfile;
import org.andromda.cartridges.nhibernate.metafacades.HibernateEmbeddedValue;
import org.andromda.cartridges.nhibernate.metafacades.HibernateEntity;
import org.andromda.cartridges.nhibernate.metafacades.HibernateEntityAttributeLogic;
import org.andromda.metafacades.uml.EntityMetafacadeUtils;
import org.apache.commons.lang.StringUtils;

public class HibernateEntityAttributeLogicImpl
extends HibernateEntityAttributeLogic {
    public HibernateEntityAttributeLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    public boolean isRequired() {
        HibernateEntity entity;
        boolean required = super.isRequired();
        if (this.getOwner() instanceof HibernateEntity && (entity = (HibernateEntity)this.getOwner()).isHibernateInheritanceClass() && entity.getGeneralization() != null) {
            required = false;
        }
        return required;
    }

    protected boolean handleIsContainsEmbeddedObject() {
        boolean returnValue = false;
        if (this.getType() instanceof HibernateEmbeddedValue) {
            returnValue = true;
        }
        return returnValue;
    }

    protected String handleConcatColumnName(String prefix, String name) {
        String returnValue = name;
        if (StringUtils.isNotBlank((String)prefix)) {
            returnValue = prefix + this.getConfiguredProperty("sqlNameSeparator") + name;
            Short maxSqlNameLength = Short.valueOf((String)this.getConfiguredProperty("maxSqlNameLength"));
            returnValue = EntityMetafacadeUtils.ensureMaximumNameLength((String)returnValue, (Short)maxSqlNameLength);
        }
        return returnValue;
    }

    protected boolean handleIsLazy() {
        String value = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_LAZY);
        return StringUtils.isNotBlank((String)value) ? Boolean.valueOf(value) : false;
    }

    protected String handleGetFormula() {
        return (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_FORMULA);
    }

    protected boolean handleIsInsertEnabled() {
        String value = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_PROPERTY_INSERT);
        return StringUtils.isNotBlank((String)value) ? Boolean.valueOf(value) : true;
    }

    protected boolean handleIsUpdateEnabled() {
        String value = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_PROPERTY_UPDATE);
        return StringUtils.isNotBlank((String)value) ? Boolean.valueOf(value) : true;
    }
}

