/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.nhibernate.metafacades;

import java.util.ArrayList;
import java.util.Collection;
import org.andromda.cartridges.nhibernate.HibernateProfile;
import org.andromda.cartridges.nhibernate.metafacades.HibernateAssociationEndLogic;
import org.andromda.cartridges.nhibernate.metafacades.HibernateEntity;
import org.andromda.cartridges.nhibernate.metafacades.HibernateType;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.EntityAssociationEnd;
import org.andromda.metafacades.uml.EntityMetafacadeUtils;
import org.andromda.metafacades.uml.TypeMappings;
import org.andromda.metafacades.uml.UMLProfile;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class HibernateAssociationEndLogicImpl
extends HibernateAssociationEndLogic {
    private static final String COLLECTION_TYPE_SET = "set";
    private static final String COLLECTION_TYPE_MAP = "map";
    private static final String COLLECTION_TYPE_BAG = "bag";
    private static final String COLLECTION_TYPE_LIST = "list";
    private static final String COLLECTION_TYPE_COLLECTION = "collection";
    private static final Collection collectionTypes = new ArrayList();
    private static final String COMPOSITION_DEFINES_EAGER_LOADING = "compositionDefinesEagerLoading";
    private static final String PROPERTY_ASSOCIATION_END_OUTERJOIN = "hibernateAssociationEndOuterJoin";
    private static final String COLLECTION_INDEX_NAME = "associationEndCollectionIndexName";
    private static final String COLLECTION_INDEX_TYPE = "associationEndCollectionIndexType";
    private static final String HIBERNATE_AGGREGATION_CASCADE = "hibernateAggregationCascade";
    private static final String HIBERNATE_COMPOSITION_CASCADE = "hibernateCompositionCascade";
    private static final String HIBERNATE_OUTER_JOIN_YES = "yes";
    private static final String HIBERNATE_OUTER_JOIN_AUTO = "auto";

    public HibernateAssociationEndLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    protected boolean handleIsOne2OnePrimary() {
        return this.isOne2One() && (this.isAggregation() || this.isComposition());
    }

    public String getGetterSetterTypeName() {
        String typeName;
        ClassifierFacade type;
        String getterSetterTypeName = super.getGetterSetterTypeName();
        if (!this.isMany() && (type = this.getType()) instanceof HibernateEntity && StringUtils.isNotEmpty((String)(typeName = ((HibernateEntity)type).getFullyQualifiedEntityName()))) {
            getterSetterTypeName = typeName;
        }
        if (this.isMany()) {
            boolean specificInterfaces = Boolean.valueOf(ObjectUtils.toString((Object)this.getConfiguredProperty("specificCollectionInterfaces")));
            TypeMappings mappings = this.getLanguageMappings();
            if (mappings != null) {
                if (this.isMap()) {
                    getterSetterTypeName = mappings.getTo(UMLProfile.MAP_TYPE_NAME);
                } else if (specificInterfaces) {
                    if (this.isSet()) {
                        getterSetterTypeName = mappings.getTo(UMLProfile.SET_TYPE_NAME);
                    } else if (this.isList()) {
                        getterSetterTypeName = mappings.getTo(UMLProfile.LIST_TYPE_NAME);
                    }
                } else {
                    getterSetterTypeName = ObjectUtils.toString((Object)this.getConfiguredProperty("defaultCollectionInterface"));
                }
            } else {
                getterSetterTypeName = ObjectUtils.toString((Object)this.getConfiguredProperty("defaultCollectionInterface"));
            }
        }
        return getterSetterTypeName;
    }

    protected boolean handleIsLazy() {
        String lazyString = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_LAZY);
        boolean lazy = true;
        if (lazyString == null) {
            boolean compositionDefinesEagerLoading = Boolean.valueOf(String.valueOf(this.getConfiguredProperty(COMPOSITION_DEFINES_EAGER_LOADING)));
            if (compositionDefinesEagerLoading) {
                lazy = !this.getOtherEnd().isComposition();
            }
        } else {
            lazy = Boolean.valueOf(lazyString);
        }
        return lazy;
    }

    protected String handleGetHibernateCascade() {
        String cascade = null;
        String individualCascade = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_CASCADE);
        if (individualCascade != null && individualCascade.length() > 0) {
            cascade = individualCascade;
        } else if (this.isChild()) {
            if (StringUtils.isBlank((String)this.getHibernateCompositionCascade())) {
                HibernateEntity entity;
                String defaultCascade;
                cascade = "delete";
                ClassifierFacade type = this.getType();
                if (type != null && type instanceof HibernateEntity && ((defaultCascade = (entity = (HibernateEntity)type).getHibernateDefaultCascade()).equalsIgnoreCase("save-update") || defaultCascade.equalsIgnoreCase("all"))) {
                    cascade = this.isMany() ? "all-delete-orphan" : "all";
                }
            } else {
                cascade = this.getHibernateCompositionCascade();
            }
        } else if (this.isComposition()) {
            cascade = "none";
        } else if (StringUtils.isNotBlank((String)this.getHibernateAggregationCascade())) {
            if (this.isAggregation()) {
                cascade = "none";
            } else if (this.getOtherEnd() != null && this.getOtherEnd().isAggregation()) {
                cascade = this.getHibernateAggregationCascade();
            }
        }
        return cascade;
    }

    protected boolean handleIsHibernateInverse() {
        boolean inverse;
        boolean bl = inverse = this.isNavigable() && this.getOtherEnd().isNavigable();
        if (inverse) {
            inverse = this.isMany2One();
            if (this.isMany2Many() && !inverse) {
                String otherEndTypeName;
                String endTypeName = StringUtils.trimToEmpty((String)this.getType().getFullyQualifiedName(true));
                int compareTo = endTypeName.compareTo(otherEndTypeName = StringUtils.trimToEmpty((String)this.getOtherEnd().getType().getFullyQualifiedName(true)));
                if (compareTo == 0) {
                    String endName = StringUtils.trimToEmpty((String)this.getName());
                    String otherEndName = StringUtils.trimToEmpty((String)this.getOtherEnd().getName());
                    compareTo = endName.compareTo(otherEndName);
                }
                inverse = compareTo < 0;
            }
        }
        return inverse;
    }

    protected String handleGetOuterJoin() {
        Object value = this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_OUTER_JOIN);
        if (value == null) {
            value = this.getConfiguredProperty(PROPERTY_ASSOCIATION_END_OUTERJOIN);
        }
        String outerValue = StringUtils.trimToEmpty((String)String.valueOf(value));
        String version = (String)this.getConfiguredProperty("hibernateVersion");
        if (version.equals("3")) {
            outerValue = outerValue.equals(HIBERNATE_OUTER_JOIN_AUTO) || outerValue.equals(HIBERNATE_OUTER_JOIN_YES) ? "select" : "join";
        }
        return outerValue;
    }

    public boolean isRequired() {
        HibernateEntity entity;
        boolean required = super.isRequired();
        ClassifierFacade type = this.getType();
        if (type != null && HibernateEntity.class.isAssignableFrom(type.getClass()) && (entity = (HibernateEntity)type).isHibernateInheritanceClass() && entity.getGeneralization() != null) {
            required = false;
        }
        return required;
    }

    protected String handleGetCollectionType() {
        String collectionType = this.getSpecificCollectionType();
        if (!collectionTypes.contains(collectionType)) {
            collectionType = this.isOrdered() ? COLLECTION_TYPE_LIST : (String)this.getConfiguredProperty("hibernateAssociationCollectionType");
        }
        return collectionType;
    }

    private String getSpecificCollectionType() {
        return ObjectUtils.toString((Object)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_ASSOCIATION_COLLECTION_TYPE));
    }

    protected String handleGetSortType() {
        return ObjectUtils.toString((Object)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_ASSOCIATION_SORT_TYPE));
    }

    protected String handleGetOrderByColumns() {
        String orderColumns = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_ASSOCIATION_ORDER_BY_COLUMNS);
        if (orderColumns == null) {
            orderColumns = ((EntityAssociationEnd)this.getOtherEnd()).getColumnName();
        }
        return orderColumns;
    }

    protected String handleGetWhereClause() {
        String whereClause = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_ASSOCIATION_WHERE_CLAUSE);
        return whereClause;
    }

    protected boolean handleIsIndexedCollection() {
        boolean indexed = false;
        if (this.isOrdered() && (this.getCollectionType().equals(COLLECTION_TYPE_LIST) || this.getCollectionType().equals(COLLECTION_TYPE_MAP)) && StringUtils.isNotBlank((String)this.getCollectionIndexName())) {
            indexed = true;
        }
        return indexed;
    }

    protected String handleGetCollectionIndexName() {
        Object value = this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_ASSOCIATION_INDEX);
        if (value == null && this.isConfiguredProperty(COLLECTION_INDEX_NAME) && StringUtils.isBlank((String)ObjectUtils.toString((Object)(value = this.getConfiguredProperty(COLLECTION_INDEX_NAME))))) {
            value = null;
        }
        if (value != null) {
            return ObjectUtils.toString((Object)value);
        }
        String otherEntityName = ((HibernateEntity)this.getOtherEnd().getType()).getEntityName();
        Object separator = this.getConfiguredProperty("sqlNameSeparator");
        return EntityMetafacadeUtils.toSqlName((String)otherEntityName, (Object)separator) + separator + EntityMetafacadeUtils.toSqlName((String)this.getName(), (Object)separator) + separator + "IDX";
    }

    protected String handleGetCollectionIndexType() {
        Object value = this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_ASSOCIATION_INDEX_TYPE);
        if (value == null && StringUtils.isBlank((String)ObjectUtils.toString((Object)(value = this.getConfiguredProperty(COLLECTION_INDEX_TYPE))))) {
            value = null;
        }
        if (value != null) {
            if (value instanceof String) {
                value = this.getRootPackage().findModelElement((String)value);
            }
            if (value instanceof HibernateType) {
                value = ((HibernateType)value).getFullyQualifiedHibernateType();
            }
        }
        return value != null ? ObjectUtils.toString((Object)value) : null;
    }

    protected boolean handleIsMap() {
        boolean isMap = this.getCollectionType().equalsIgnoreCase(COLLECTION_TYPE_MAP);
        if (isMap && StringUtils.isBlank((String)this.getSpecificCollectionType())) {
            isMap = !this.isOrdered();
        }
        return isMap;
    }

    protected boolean handleIsList() {
        boolean isList = this.getCollectionType().equalsIgnoreCase(COLLECTION_TYPE_LIST);
        if (!isList && StringUtils.isBlank((String)this.getSpecificCollectionType())) {
            isList = this.isOrdered();
        }
        return isList;
    }

    protected boolean handleIsSet() {
        boolean isSet = this.getCollectionType().equalsIgnoreCase(COLLECTION_TYPE_SET);
        if (isSet && StringUtils.isBlank((String)this.getSpecificCollectionType())) {
            isSet = !this.isOrdered();
        }
        return isSet;
    }

    protected boolean handleIsBag() {
        return this.getCollectionType().equalsIgnoreCase(COLLECTION_TYPE_BAG);
    }

    protected String handleGetCollectionTypeImplementation() {
        StringBuffer implementation = new StringBuffer();
        if (this.isMany()) {
            implementation.append("new ");
            if (this.isSet()) {
                implementation.append(this.getConfiguredProperty("setTypeImplementation"));
            } else if (this.isMap()) {
                implementation.append(this.getConfiguredProperty("mapTypeImplementation"));
            } else if (this.isBag()) {
                implementation.append(this.getConfiguredProperty("bagTypeImplementation"));
            } else if (this.isList()) {
                implementation.append(this.getConfiguredProperty("listTypeImplementation"));
            }
            implementation.append("()");
        }
        return implementation.toString();
    }

    protected String handleGetHibernateAggregationCascade() {
        return StringUtils.trimToEmpty((String)ObjectUtils.toString((Object)this.getConfiguredProperty(HIBERNATE_AGGREGATION_CASCADE)));
    }

    protected String handleGetHibernateCompositionCascade() {
        return StringUtils.trimToEmpty((String)ObjectUtils.toString((Object)this.getConfiguredProperty(HIBERNATE_COMPOSITION_CASCADE)));
    }

    static {
        collectionTypes.add(COLLECTION_TYPE_SET);
        collectionTypes.add(COLLECTION_TYPE_MAP);
        collectionTypes.add(COLLECTION_TYPE_BAG);
        collectionTypes.add(COLLECTION_TYPE_LIST);
        collectionTypes.add(COLLECTION_TYPE_COLLECTION);
    }
}

