/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.translation.ocl.testsuite;

import java.util.Iterator;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.andromda.core.AndroMDA;
import org.andromda.core.configuration.Configuration;
import org.andromda.core.configuration.Model;
import org.andromda.core.configuration.Repository;
import org.andromda.core.metafacade.MetafacadeFactory;
import org.andromda.core.metafacade.ModelAccessFacade;
import org.andromda.core.repository.Repositories;
import org.andromda.core.repository.RepositoryFacade;
import org.andromda.core.translation.Expression;
import org.andromda.core.translation.ExpressionTranslator;
import org.andromda.core.translation.TranslationUtils;
import org.andromda.translation.ocl.testsuite.ContextElementFinder;
import org.andromda.translation.ocl.testsuite.ExpressionTest;
import org.andromda.translation.ocl.testsuite.TraceTranslator;
import org.andromda.translation.ocl.testsuite.TranslationTest;
import org.andromda.translation.ocl.testsuite.TranslationTestDiscoverer;
import org.andromda.translation.ocl.testsuite.TranslationTestProcessorException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class TranslationTestProcessor
extends TestCase {
    private static final Logger logger = Logger.getLogger(TranslationTestProcessor.class);
    private static TranslationTestProcessor instance;
    private boolean useTraceTranslator;
    private String translationName;
    private String testSourceDirectory;
    private static final TranslationTestDiscoverer testDiscoverer;
    private String testTranslation = null;
    private TestResult testResult;
    private Configuration configuration;
    private ModelAccessFacade model;

    public static final TranslationTestProcessor instance() {
        if (instance == null) {
            instance = new TranslationTestProcessor();
        }
        return instance;
    }

    private TranslationTestProcessor() {
    }

    public void setUseTraceTranslator(boolean useTraceTranslator) {
        this.useTraceTranslator = useTraceTranslator;
    }

    public void setTranslationName(String translationName) {
        this.translationName = translationName;
    }

    public void setTestSourceDirectory(String testSourceDirectory) {
        this.testSourceDirectory = testSourceDirectory;
    }

    private TranslationTestProcessor(String testName) {
        super(testName);
    }

    public void setResult(TestResult testResult) {
        this.testResult = testResult;
    }

    public void runSuite() {
        if (this.testResult == null) {
            throw new TranslationTestProcessorException("You must set the test result before attempting to run the suite");
        }
        AndroMDA andromda = AndroMDA.newInstance();
        MetafacadeFactory factory = MetafacadeFactory.getInstance();
        andromda.initialize(this.configuration);
        factory.setNamespace("default");
        if (this.model == null) {
            Repositories repositoriesContainer = Repositories.instance();
            Repository[] repositories = this.configuration.getRepositories();
            if (repositories != null && repositories.length > 0) {
                for (Repository repository : repositories) {
                    Model[] models = repository.getModels();
                    if (models == null) continue;
                    Model model = models[0];
                    repositoriesContainer.loadModel(model);
                    RepositoryFacade repositoryImplementation = repositoriesContainer.getImplementation(repository.getName());
                    this.model = repositoryImplementation.getModel();
                    factory.setModel(this.model, model.getType());
                }
            }
        }
        this.getSuite().run(this.testResult);
        andromda.shutdown();
    }

    private TestSuite getSuite() {
        testDiscoverer.discoverTests(this.testSourceDirectory);
        Map<String, TranslationTest> tests = testDiscoverer.getTests();
        TestSuite suite = new TestSuite();
        Iterator<String> iterator = tests.keySet().iterator();
        while (iterator.hasNext()) {
            TranslationTestProcessor unitTest = new TranslationTestProcessor("testTranslation");
            unitTest.setConfiguration(this.configuration);
            unitTest.setTestTranslation(iterator.next());
            unitTest.model = this.model;
            suite.addTest((Test)unitTest);
        }
        return suite;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    private void setTestTranslation(String testTranslation) {
        this.testTranslation = testTranslation;
    }

    protected Object findModelElement(String translation, String expression) {
        String methodName = "TranslationTestProcessor.findClassifier";
        Object element = null;
        if (StringUtils.isNotBlank((String)expression)) {
            if (this.model == null) {
                throw new RuntimeException("TranslationTestProcessor.findClassifier could not retrieve model from repository");
            }
            ContextElementFinder finder = new ContextElementFinder(this.model);
            finder.translate(translation, expression, null);
            element = finder.getContextElement();
            if (element == null) {
                String message = "No element found in model in expression --> '" + expression + "' for translation ' " + translation + "', please check your model or your TranslationTest file";
                logger.error((Object)("ERROR! " + message));
                TestCase.fail((String)message);
            }
        }
        return element;
    }

    public void testTranslation() {
        String translation = this.testTranslation;
        if (this.shouldTest(translation)) {
            TranslationTest test;
            Map<String, ExpressionTest> expressions;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("testing translation --> '" + translation + '\''));
            }
            if ((expressions = (test = testDiscoverer.getTest(translation)).getExpressionConfigs()) != null) {
                for (String fromExpression : expressions.keySet()) {
                    Expression translated;
                    if (StringUtils.isEmpty((String)fromExpression)) {
                        if (!logger.isInfoEnabled()) continue;
                        logger.info((Object)("No body for the 'from' element was defined within translation test --> '" + test.getUri() + "', please define the body of this element with " + "the expression you want to translate from"));
                        continue;
                    }
                    if (this.useTraceTranslator) {
                        translated = TraceTranslator.getInstance().translate(translation, fromExpression, null);
                        continue;
                    }
                    ExpressionTest expressionConfig = expressions.get(fromExpression);
                    String toExpression = expressionConfig.getTo();
                    Object modelElement = null;
                    Repository[] repositories = this.configuration.getRepositories();
                    if (repositories != null && repositories.length > 0) {
                        modelElement = this.findModelElement(translation, fromExpression);
                    } else {
                        logger.info((Object)"No repositories defined in configuration, not finding for model elements");
                    }
                    if ((translated = ExpressionTranslator.instance().translate(translation, fromExpression, modelElement)) == null) continue;
                    toExpression = TranslationUtils.removeExtraWhitespace((String)toExpression);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("translated: --> '" + translated.getTranslatedExpression() + '\''));
                        logger.info((Object)("expected:   --> '" + toExpression + '\''));
                    }
                    TestCase.assertEquals((String)toExpression, (String)translated.getTranslatedExpression());
                }
            }
        } else if (logger.isInfoEnabled()) {
            logger.info((Object)("skipping translation --> '" + translation + '\''));
        }
    }

    private boolean shouldTest(String translation) {
        translation = StringUtils.trimToEmpty((String)translation);
        return StringUtils.isEmpty((String)this.translationName) || StringUtils.isNotBlank((String)this.translationName) && this.translationName.equals(translation);
    }

    public void shutdown() {
        testDiscoverer.shutdown();
        instance = null;
    }

    static {
        testDiscoverer = TranslationTestDiscoverer.instance();
    }
}

