/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.translation.ocl.testsuite;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.ResourceUtils;
import org.andromda.core.translation.Expression;
import org.andromda.core.translation.TranslationUtils;
import org.andromda.core.translation.Translator;
import org.andromda.core.translation.TranslatorException;
import org.andromda.translation.ocl.BaseTranslator;
import org.apache.log4j.Logger;

public class TraceTranslator
extends BaseTranslator {
    private static final Logger logger = Logger.getLogger(TraceTranslator.class);
    private static final String INA_PREFIX = "inA";
    private static final String OUTA_PREFIX = "outA";
    private static final String CASE_PREFIX = "case";
    private Map<CtMethod, String> methods = new HashMap<CtMethod, String>();
    private static final String FIELD_ADAPTED = "adapted";
    private ClassPool pool;

    public static Translator getInstance() {
        String debugMethodName = "TraceTranslator.getInstance";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"performing TraceTranslator.getInstance");
        }
        try {
            TraceTranslator oclTranslator;
            TraceTranslator translator = oclTranslator = new TraceTranslator();
            if (oclTranslator.needsAdaption()) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)" OCL Translator has not been adapted --> adapting");
                }
                translator = (Translator)oclTranslator.getAdaptedTranslationClass().newInstance();
            }
            return translator;
        }
        catch (Exception ex) {
            String errMsg = "Error performing TraceTranslator.getInstance";
            logger.error((Object)errMsg, (Throwable)ex);
            throw new TranslatorException(errMsg, (Throwable)ex);
        }
    }

    public Expression translate(String translationName, String expression, Object contextElement) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"======================== Tracing Expression ========================");
            logger.info((Object)TranslationUtils.removeExtraWhitespace((String)expression));
            logger.info((Object)"======================== ================== ========================");
        }
        Expression expressionObj = super.translate(translationName, expression, contextElement);
        if (logger.isInfoEnabled()) {
            logger.info((Object)"========================  Tracing Complete  ========================");
        }
        return expressionObj;
    }

    protected boolean needsAdaption() {
        boolean needsAdaption = false;
        try {
            ((Object)((Object)this)).getClass().getDeclaredField(FIELD_ADAPTED);
        }
        catch (NoSuchFieldException ex) {
            needsAdaption = true;
        }
        return needsAdaption;
    }

    protected Class getAdaptedTranslationClass() throws NotFoundException, CannotCompileException, IOException {
        Class<?> thisClass = ((Object)((Object)this)).getClass();
        this.pool = TranslatorClassPool.getPool(thisClass.getClassLoader());
        CtClass ctTranslatorClass = this.pool.get(thisClass.getName());
        CtField adaptedField = new CtField(CtClass.booleanType, FIELD_ADAPTED, ctTranslatorClass);
        ctTranslatorClass.addField(adaptedField);
        CtMethod[] analysisMethods = ctTranslatorClass.getMethods();
        if (analysisMethods != null) {
            for (CtMethod method : analysisMethods) {
                String methodName = method.getName();
                if (methodName.startsWith(INA_PREFIX)) {
                    this.methods.put(method, this.getInAMethodBody(method));
                    continue;
                }
                if (methodName.startsWith(OUTA_PREFIX)) {
                    this.methods.put(method, this.getOutAMethodBody(method));
                    continue;
                }
                if (!methodName.startsWith(CASE_PREFIX)) continue;
                this.methods.put(method, this.getCaseMethodBody(method));
            }
            for (CtMethod method : this.methods.keySet()) {
                CtMethod newMethod = new CtMethod(method, ctTranslatorClass, null);
                String methodBody = this.methods.get(method);
                newMethod.setBody(methodBody);
                ctTranslatorClass.addMethod(newMethod);
            }
        }
        this.writeAdaptedClass(ctTranslatorClass);
        return ctTranslatorClass.toClass();
    }

    protected void writeAdaptedClass(CtClass pTranslatorClass) {
        String methodName = "TraceTranslator.writeAdaptedClass";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"performing TraceTranslator.writeAdaptedClass");
        }
        try {
            File dir = this.getAdaptedClassOutputDirectory();
            if (logger.isDebugEnabled()) {
                String className = ((Object)((Object)this)).getClass().getName();
                logger.debug((Object)("writing className '" + className + "' to directory --> " + '\'' + dir + '\''));
            }
            pTranslatorClass.writeFile(dir.getPath());
        }
        catch (Exception ex) {
            String errMsg = "Error performing TraceTranslator.writeAdaptedClass";
            logger.error((Object)errMsg, (Throwable)ex);
            throw new TranslatorException(errMsg, (Throwable)ex);
        }
    }

    protected File getAdaptedClassOutputDirectory() {
        String methodName = "TraceTranslator.getAdaptedClassOutputDirectory";
        Class<?> thisClass = ((Object)((Object)this)).getClass();
        URL classAsResource = ResourceUtils.getClassResource((String)thisClass.getName());
        File file = new File(classAsResource.getFile());
        File dir = file.getParentFile();
        if (dir == null) {
            throw new TranslatorException("TraceTranslator.getAdaptedClassOutputDirectory - can not retrieve directory for file '" + file + '\'');
        }
        String className = thisClass.getName();
        int index = className.indexOf(46);
        String basePackage = null;
        if (index != -1) {
            basePackage = className.substring(0, index);
        }
        if (basePackage != null) {
            while (!dir.toString().endsWith(basePackage)) {
                dir = dir.getParentFile();
            }
            dir = dir.getParentFile();
        }
        return dir;
    }

    protected String getCaseMethodBody(CtMethod method) {
        ExceptionUtils.checkNull((String)"method", (Object)method);
        StringBuilder methodBody = new StringBuilder("{");
        String methodName = method.getName();
        methodBody.append("String methodName = \"").append(methodName).append("\";");
        methodBody.append(this.getMethodTrace(method));
        methodBody.append("super.").append(methodName).append("($1);");
        methodBody.append('}');
        return methodBody.toString();
    }

    protected String getInAMethodBody(CtMethod method) {
        ExceptionUtils.checkNull((String)"method", (Object)method);
        StringBuilder methodBody = new StringBuilder("{");
        String methodName = method.getName();
        methodBody.append("String methodName = \"").append(methodName).append("\";");
        methodBody.append(this.getMethodTrace(method));
        methodBody.append("super.").append(methodName).append("($1);");
        methodBody.append('}');
        return methodBody.toString();
    }

    protected String getOutAMethodBody(CtMethod method) {
        ExceptionUtils.checkNull((String)"method", (Object)method);
        StringBuilder methodBody = new StringBuilder("{");
        String methodName = method.getName();
        methodBody.append("String methodName = \"").append(methodName).append("\";");
        methodBody.append(this.getMethodTrace(method));
        methodBody.append("super.").append(methodName).append("($1);");
        methodBody.append('}');
        return methodBody.toString();
    }

    protected String getOclFragmentName(CtMethod method) {
        ExceptionUtils.checkNull((String)"method", (Object)method);
        String fragment = method.getName();
        String prefix = this.getMethodPrefix(method);
        int index = fragment.indexOf(prefix);
        if (index != -1) {
            fragment = fragment.substring(index + prefix.length(), fragment.length());
        }
        return fragment;
    }

    protected String getMethodPrefix(CtMethod method) {
        ExceptionUtils.checkNull((String)"method", (Object)method);
        String mName = method.getName();
        String prefix = INA_PREFIX;
        if (mName.startsWith(OUTA_PREFIX)) {
            prefix = OUTA_PREFIX;
        }
        return prefix;
    }

    protected String getMethodTrace(CtMethod method) {
        ExceptionUtils.checkNull((String)"method", (Object)method);
        StringBuilder buf = new StringBuilder("if (logger.isInfoEnabled()) {logger.info(\"");
        buf.append("\" + methodName + \" --> ");
        buf.append("'\" + org.andromda.core.translation.TranslationUtils.trimToEmpty($1) + \"'\");}");
        return buf.toString();
    }

    protected static void adaptClass() {
        TraceTranslator translator;
        if (logger.isInfoEnabled()) {
            logger.info((Object)"adapting class for OCL parser");
        }
        if ((translator = new TraceTranslator()).needsAdaption()) {
            try {
                translator.getAdaptedTranslationClass();
            }
            catch (Throwable th) {
                logger.error((Object)th);
            }
        }
    }

    public static void main(String[] args) {
        try {
            AndroMDALogger.initialize();
            TraceTranslator.adaptClass();
        }
        catch (Throwable th) {
            logger.error((Object)th);
        }
    }

    public void postProcess() {
    }

    private static class TranslatorClassPool
    extends ClassPool {
        private static final Logger logger = Logger.getLogger(TranslatorClassPool.class);
        private static LocalClassLoader classLoader = new LocalClassLoader(LocalClassLoader.class.getClassLoader());

        protected TranslatorClassPool() {
            super(ClassPool.getDefault());
            if (logger.isInfoEnabled()) {
                logger.debug((Object)"instantiating new TranslatorClassPool");
            }
        }

        protected static ClassPool getPool(ClassLoader loader) {
            if (loader == null) {
                loader = Thread.currentThread().getContextClassLoader();
            }
            TranslatorClassPool pool = new TranslatorClassPool();
            pool.insertClassPath((ClassPath)new LoaderClassPath(loader));
            return pool;
        }

        public Class writeAsClass(String classname) throws NotFoundException, IOException, CannotCompileException {
            try {
                CtClass ctTranslatorClass = this.get(classname);
                return classLoader.loadClass(classname, ctTranslatorClass.toBytecode());
            }
            catch (ClassFormatError e) {
                throw new CannotCompileException(e, classname);
            }
        }

        static class LocalClassLoader
        extends ClassLoader {
            public LocalClassLoader(ClassLoader parent) {
                super(parent);
            }

            public Class loadClass(String name, byte[] classfile) throws ClassFormatError {
                Class<?> c = this.defineClass(name, classfile, 0, classfile.length);
                this.resolveClass(c);
                return c;
            }
        }
    }
}

