/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.translation.ocl.testsuite;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.andromda.core.common.XmlObjectFactory;
import org.andromda.translation.ocl.testsuite.TranslationTest;
import org.andromda.translation.ocl.testsuite.TranslationTestDiscovererException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TranslationTestDiscoverer {
    private static Logger logger = Logger.getLogger((Class)TranslationTestDiscoverer.class);
    private static final String TEST_PREFIX = "TranslationTest-";
    private static final List IGNORED_DIRECTORIES = Arrays.asList("CVS", ".svn");
    private Map translationTests = new LinkedHashMap();
    private static TranslationTestDiscoverer instance;
    static /* synthetic */ Class class$org$andromda$translation$ocl$testsuite$TranslationTest;

    public static TranslationTestDiscoverer instance() {
        if (instance == null) {
            instance = new TranslationTestDiscoverer();
        }
        return instance;
    }

    public void discoverTests(String directory) {
        if (directory == null || directory.trim().length() == 0) {
            throw new TranslationTestDiscovererException("The 'directory'  was not specified, please specify this value with the location from which to begin the discovery of translation test files");
        }
        if (this.translationTests.isEmpty()) {
            this.discoverTests(new File(directory));
        }
    }

    private void discoverTests(File currentDirectory) {
        try {
            String[] files = currentDirectory.list();
            if (files == null || files.length == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("no files or directories found in directory '" + currentDirectory + "'"));
                }
            } else {
                for (int ctr = 0; ctr < files.length; ++ctr) {
                    File file = new File(currentDirectory, files[ctr]);
                    if (StringUtils.trimToEmpty((String)file.getName()).startsWith(TEST_PREFIX)) {
                        URL testUrl = file.toURL();
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("found translation test --> '" + testUrl + "'"));
                        }
                        TranslationTest test = (TranslationTest)XmlObjectFactory.getInstance((Class)(class$org$andromda$translation$ocl$testsuite$TranslationTest == null ? TranslationTestDiscoverer.class$("org.andromda.translation.ocl.testsuite.TranslationTest") : class$org$andromda$translation$ocl$testsuite$TranslationTest)).getObject(testUrl);
                        test.setUri(testUrl);
                        this.translationTests.put(test.getTranslation(), test);
                        continue;
                    }
                    if (!file.isDirectory() || IGNORED_DIRECTORIES.contains(file.getName())) continue;
                    this.discoverTests(file);
                }
            }
        }
        catch (Throwable throwable) {
            logger.error((Object)throwable);
            throw new TranslationTestDiscovererException(throwable);
        }
    }

    public TranslationTest getTest(String translation) {
        return (TranslationTest)this.translationTests.get(StringUtils.trimToEmpty((String)translation));
    }

    public Map getTests() {
        return this.translationTests;
    }

    public void shutdown() {
        this.translationTests.clear();
        instance = null;
    }
}

