/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.translation.ocl.testsuite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.metafacade.ModelAccessFacade;
import org.andromda.core.translation.Expression;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.OperationFacade;
import org.andromda.metafacades.uml.ParameterFacade;
import org.andromda.translation.ocl.BaseTranslator;
import org.andromda.translation.ocl.node.AOperationContextDeclaration;
import org.andromda.translation.ocl.node.POperation;
import org.andromda.translation.ocl.syntax.ConcreteSyntaxUtils;
import org.andromda.translation.ocl.syntax.OperationDeclaration;
import org.andromda.translation.ocl.syntax.VariableDeclaration;
import org.andromda.translation.ocl.testsuite.ContextElementFinderException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;

public class ContextElementFinder
extends BaseTranslator {
    private ModelAccessFacade model;
    protected OperationDeclaration operation = null;
    private Object contextElement = null;
    static /* synthetic */ Class class$org$andromda$metafacades$uml$ModelElementFacade;

    public ContextElementFinder(ModelAccessFacade model) {
        ExceptionUtils.checkNull((String)"model", (Object)model);
        this.model = model;
    }

    private ContextElementFinder() {
    }

    public void inAOperationContextDeclaration(AOperationContextDeclaration declaration) {
        super.inAOperationContextDeclaration(declaration);
        if (declaration != null) {
            this.operation = ConcreteSyntaxUtils.getOperationDeclaration((POperation)declaration.getOperation());
        }
    }

    public void postProcess() {
        super.postProcess();
        Expression expression = this.getExpression();
        if (expression != null) {
            String contextElementName = expression.getContextElement();
            this.contextElement = this.findModelElement(contextElementName.replaceAll("::", "\\."));
            if (this.contextElement != null) {
                this.logger.info((Object)("found context element --> '" + contextElementName + "'"));
            } else {
                this.logger.info((Object)("Could not find model element --> '" + contextElementName + "'"));
            }
            if (this.contextElement != null && this.operation != null && ClassifierFacade.class.isAssignableFrom(this.contextElement.getClass())) {
                ClassifierFacade type = (ClassifierFacade)this.contextElement;
                Collection operations = type.getOperations();
                this.contextElement = CollectionUtils.find((Collection)operations, (Predicate)new OperationFinder());
                if (this.contextElement == null) {
                    throw new ContextElementFinderException("No operation matching '" + this.operation + "' could be found on element --> '" + contextElementName + "', please check your model");
                }
                if (operations.size() == 1) {
                    this.contextElement = operations.iterator().next();
                }
            }
        }
    }

    protected boolean argumentsMatch(OperationDeclaration oclOperation, OperationFacade facadeOperation) {
        boolean argumentsMatch = this.argumentCountsMatch(oclOperation, facadeOperation);
        if (argumentsMatch) {
            argumentsMatch = this.argumentNamesMatch(oclOperation, facadeOperation);
        }
        return argumentsMatch;
    }

    private boolean argumentCountsMatch(OperationDeclaration oclOperation, OperationFacade facadeOperation) {
        boolean countsMatch;
        ExceptionUtils.checkNull((String)"oclOperation", (Object)oclOperation);
        ExceptionUtils.checkNull((String)"facadeOperation", (Object)facadeOperation);
        VariableDeclaration[] expressionOpArgs = oclOperation.getArguments();
        Collection facadeOpArgs = facadeOperation.getArguments();
        boolean bl = countsMatch = !(expressionOpArgs != null && expressionOpArgs.length != 0 || facadeOpArgs != null && !facadeOpArgs.isEmpty());
        if (!countsMatch) {
            countsMatch = expressionOpArgs != null && facadeOpArgs != null && expressionOpArgs.length == facadeOpArgs.size();
        }
        return countsMatch;
    }

    private boolean argumentNamesMatch(OperationDeclaration oclOperation, OperationFacade facadeOperation) {
        ExceptionUtils.checkNull((String)"oclOperation", (Object)oclOperation);
        ExceptionUtils.checkNull((String)"facadeOperation", (Object)facadeOperation);
        Collection facadeOpArguments = facadeOperation.getArguments();
        VariableDeclaration[] expressionOpArgs = oclOperation.getArguments();
        ArrayList<String> expressionArgNames = new ArrayList<String>();
        if (expressionOpArgs != null) {
            for (int ctr = 0; ctr < expressionOpArgs.length; ++ctr) {
                expressionArgNames.add(expressionOpArgs[ctr].getName());
            }
        }
        ArrayList<String> facadeArgNames = new ArrayList<String>();
        if (facadeOpArguments != null) {
            Iterator facadeOpArgumentIt = facadeOpArguments.iterator();
            while (facadeOpArgumentIt.hasNext()) {
                ParameterFacade facadeArg = (ParameterFacade)facadeOpArgumentIt.next();
                facadeArgNames.add(facadeArg.getName());
            }
        }
        return CollectionUtils.isEqualCollection(expressionArgNames, facadeArgNames);
    }

    private Object findModelElement(final String modelElementName) {
        Object modelElement = null;
        Collection modelElements = this.model.getModelElements();
        CollectionUtils.filter((Collection)modelElements, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                String name;
                ModelElementFacade modelElement;
                String elementName;
                boolean valid = false;
                if ((class$org$andromda$metafacades$uml$ModelElementFacade == null ? (class$org$andromda$metafacades$uml$ModelElementFacade = ContextElementFinder.class$("org.andromda.metafacades.uml.ModelElementFacade")) : class$org$andromda$metafacades$uml$ModelElementFacade).isAssignableFrom(object.getClass()) && !(valid = (elementName = StringUtils.trimToEmpty((String)(modelElement = (ModelElementFacade)object).getName())).equals(name = StringUtils.trimToEmpty((String)modelElementName)))) {
                    elementName = StringUtils.trimToEmpty((String)modelElement.getFullyQualifiedName());
                    valid = elementName.equals(name);
                }
                return valid;
            }
        });
        if (modelElements.size() > 1) {
            throw new ContextElementFinderException("More than one element named '" + modelElementName + "' was found within your model," + " please give the fully qualified name");
        }
        if (modelElements.size() == 1) {
            modelElement = modelElements.iterator().next();
        }
        return modelElement;
    }

    public Object getContextElement() {
        return this.contextElement;
    }

    private final class OperationFinder
    implements Predicate {
        private OperationFinder() {
        }

        public boolean evaluate(Object object) {
            OperationFacade facadeOperation = (OperationFacade)object;
            boolean valid = StringUtils.trimToEmpty((String)facadeOperation.getName()).equals(StringUtils.trimToEmpty((String)ContextElementFinder.this.operation.getName()));
            if (valid) {
                valid = ContextElementFinder.this.argumentsMatch(ContextElementFinder.this.operation, facadeOperation);
            }
            return valid;
        }
    }
}

