/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.maven.plugin.configuration;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.andromda.core.common.ResourceUtils;
import org.andromda.core.configuration.Configuration;
import org.andromda.maven.plugin.configuration.BeanProperties;
import org.andromda.maven.plugin.configuration.ConfigurationClassLoader;
import org.apache.commons.lang.ObjectUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.resources.PropertyUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.InterpolationFilterReader;

public abstract class AbstractConfigurationMojo
extends AbstractMojo {
    private static final String MAPPINGS_PATH = "META-INF/andromda/mappings";
    private static final String BEGIN_TOKEN = "${";
    private static final String END_TOKEN = "}";

    protected Configuration getConfiguration(URL configurationUri) throws IOException {
        String contents = this.replaceProperties(ResourceUtils.getContents((URL)configurationUri));
        Configuration configuration = Configuration.getInstance((String)contents);
        URL mappingsUrl = ResourceUtils.getResource((String)MAPPINGS_PATH);
        if (mappingsUrl != null) {
            configuration.addMappingsSearchLocation(mappingsUrl.toString());
        }
        return configuration;
    }

    protected Properties getProperties() throws IOException {
        Properties properties = new Properties();
        ((Hashtable)properties).put("settings", this.getSettings());
        ((Hashtable)properties).putAll(this.getProject().getProperties());
        Iterator<Object> iterator = this.getPropertyFiles().iterator();
        while (iterator.hasNext()) {
            String propertiesFile = (String)iterator.next();
            Properties projectProperties = PropertyUtils.loadPropertyFile((File)new File(propertiesFile), (boolean)true, (boolean)true);
            ((Hashtable)properties).putAll(projectProperties);
        }
        iterator = ((Hashtable)properties).keySet().iterator();
        while (iterator.hasNext()) {
            String property = (String)iterator.next();
            String value = this.replaceProperties(properties, ObjectUtils.toString(((Hashtable)properties).get(property)));
            ((Hashtable)properties).put(property, value);
        }
        ((Hashtable)properties).putAll(System.getProperties());
        return properties;
    }

    protected String replaceProperties(String string) throws IOException {
        return this.replaceProperties(this.getProperties(), string);
    }

    private String replaceProperties(Properties properties, String string) throws IOException {
        StringReader stringReader = new StringReader(string);
        InterpolationFilterReader reader = new InterpolationFilterReader((Reader)stringReader, (Map)properties, BEGIN_TOKEN, END_TOKEN);
        reader.reset();
        reader = new InterpolationFilterReader((Reader)reader, (Map)new BeanProperties(this.getProject()), BEGIN_TOKEN, END_TOKEN);
        reader = new InterpolationFilterReader((Reader)reader, (Map)new BeanProperties(this.getSettings()), BEGIN_TOKEN, END_TOKEN);
        return ResourceUtils.getContents((Reader)reader);
    }

    protected void initializeClasspathFromClassPathElements(List classpathFiles) throws MalformedURLException {
        if (classpathFiles != null && classpathFiles.size() > 0) {
            URL[] classpathUrls = new URL[classpathFiles.size()];
            for (int ctr = 0; ctr < classpathFiles.size(); ++ctr) {
                File file = new File((String)classpathFiles.get(ctr));
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("adding to classpath '" + file + "'"));
                }
                classpathUrls[ctr] = file.toURL();
            }
            ConfigurationClassLoader loader = new ConfigurationClassLoader(classpathUrls, Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    protected void addPluginDependencies(String pluginArtifactId, String scope) {
        List plugins;
        if (pluginArtifactId != null && (plugins = this.getPlugins()) != null && !plugins.isEmpty()) {
            Iterator iterator = plugins.iterator();
            while (iterator.hasNext()) {
                List dependencies;
                Plugin plugin = (Plugin)iterator.next();
                if (!pluginArtifactId.equals(plugin.getArtifactId()) || (dependencies = plugin.getDependencies()) == null) continue;
                Iterator dependencyIterator = plugin.getDependencies().iterator();
                while (dependencyIterator.hasNext()) {
                    this.addDependency((Dependency)dependencyIterator.next(), scope);
                }
            }
        }
    }

    private void addDependency(Dependency dependency, String scope) {
        ArtifactRepository localRepository = this.getLocalRepository();
        MavenProject project = this.getProject();
        if (project != null && localRepository != null && dependency != null) {
            Artifact artifact = this.getFactory().createArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), scope, dependency.getType());
            File file = new File(localRepository.getBasedir(), localRepository.pathOf(artifact));
            artifact.setFile(file);
            project.getDependencies().add(dependency);
            project.getArtifacts().add(artifact);
        }
    }

    protected abstract MavenProject getProject();

    protected abstract List getPropertyFiles();

    protected abstract Settings getSettings();

    protected abstract ArtifactFactory getFactory();

    protected abstract List getPlugins();

    protected abstract ArtifactRepository getLocalRepository();
}

