/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.meta.metafacades;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.andromda.cartridges.meta.MetaProfile;
import org.andromda.cartridges.meta.metafacades.Metafacade;
import org.andromda.cartridges.meta.metafacades.MetafacadeGeneralization;
import org.andromda.cartridges.meta.metafacades.MetafacadeLogic;
import org.andromda.cartridges.meta.metafacades.MethodData;
import org.andromda.cartridges.meta.metafacades.UMLOperationData;
import org.andromda.core.metafacade.MetafacadeException;
import org.andromda.metafacades.uml.AssociationEndFacade;
import org.andromda.metafacades.uml.AttributeFacade;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.DependencyFacade;
import org.andromda.metafacades.uml.GeneralizableElementFacade;
import org.andromda.metafacades.uml.GeneralizationFacade;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.OperationFacade;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class MetafacadeLogicImpl
extends MetafacadeLogic {
    private static final String METAMODEL_VERSION_PACKAGE = "metamodelVersionPackage";
    private Map featureMap = null;

    public MetafacadeLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    protected Object handleGetMetaclass() {
        return this.getMetaclass(this);
    }

    private ClassifierFacade getMetaclass(ClassifierFacade classifier) {
        Iterator iter = classifier.getSourceDependencies().iterator();
        while (iter.hasNext()) {
            String stereotypeName;
            DependencyFacade dep = (DependencyFacade)iter.next();
            ClassifierFacade target = (ClassifierFacade)dep.getTargetElement();
            Collection stereotypes = target.getStereotypeNames();
            if (stereotypes == null || stereotypes.size() <= 0 || !(stereotypeName = (String)stereotypes.iterator().next()).equals(MetaProfile.STEREOTYPE_METACLASS)) continue;
            return target;
        }
        ClassifierFacade superclass = (ClassifierFacade)classifier.getGeneralization();
        return superclass != null ? this.getMetaclass(superclass) : null;
    }

    protected boolean handleIsMetaclassDirectDependency() {
        ModelElementFacade targetElement;
        DependencyFacade dependency;
        boolean isMetaClassDirectDependency = false;
        Collection dependencies = this.getSourceDependencies();
        if (dependencies != null && !dependencies.isEmpty() && (dependency = (DependencyFacade)dependencies.iterator().next()) != null && (targetElement = dependency.getTargetElement()) != null) {
            isMetaClassDirectDependency = targetElement.hasStereotype(MetaProfile.STEREOTYPE_METACLASS);
        }
        return isMetaClassDirectDependency;
    }

    protected String handleGetLogicName() {
        return this.getName() + "Logic";
    }

    protected String handleGetLogicImplName() {
        return this.getName() + "LogicImpl";
    }

    protected String handleGetFullyQualifiedLogicImplName() {
        return this.getMetafacadeSupportClassName(this.getLogicImplName());
    }

    protected String handleGetFullyQualifiedLogicName() {
        return this.getMetafacadeSupportClassName(this.getLogicName());
    }

    protected String handleGetLogicFile() {
        return this.getFullyQualifiedLogicName().replace('.', '/') + ".java";
    }

    private String getMetaModelVersionPackage() {
        return ObjectUtils.toString((Object)this.getConfiguredProperty(METAMODEL_VERSION_PACKAGE));
    }

    protected String handleGetLogicPackageName() {
        String packageName = this.getMetaModelVersionPackage();
        if (StringUtils.isEmpty((String)packageName)) {
            packageName = this.getPackageName();
        }
        return packageName;
    }

    protected String handleGetLogicImplFile() {
        return this.getFullyQualifiedLogicImplName().replace('.', '/') + ".java";
    }

    private String getMetafacadeSupportClassName(String name) {
        StringBuffer fullyQualifiedName = new StringBuffer(this.getLogicPackageName());
        if (StringUtils.isNotBlank((String)fullyQualifiedName.toString())) {
            fullyQualifiedName.append(".");
            fullyQualifiedName.append(name);
        }
        return fullyQualifiedName.toString();
    }

    protected Collection handleGetMethodDataForPSM(ClassifierFacade facade) {
        return this.getMethodDataForPSM(facade, true);
    }

    protected Collection handleGetMethodDataForPSM() {
        return this.getMethodDataForPSM(null, false);
    }

    private final Collection getMethodDataForPSM(ClassifierFacade facade, boolean includeSuperclasses) {
        try {
            Collection features;
            HashMap methodDataMap;
            LinkedHashSet declarationSet = new LinkedHashSet();
            if (this.featureMap == null) {
                this.featureMap = new HashMap();
                if (includeSuperclasses && this.getGeneralizations() != null) {
                    Iterator iterator = this.getGeneralizations().iterator();
                    while (iterator.hasNext()) {
                        ClassifierFacade metafacade;
                        methodDataMap = new HashMap();
                        ClassifierFacade classifier = metafacade = (ClassifierFacade)iterator.next();
                        while (classifier instanceof Metafacade) {
                            this.getAllFeatures(methodDataMap, declarationSet, (Metafacade)classifier);
                            classifier = (ClassifierFacade)classifier.getGeneralization();
                        }
                        this.featureMap.put(metafacade, methodDataMap.values());
                    }
                }
            }
            ArrayList result = new ArrayList();
            if (this.featureMap != null && (features = (Collection)this.featureMap.get(facade)) != null) {
                result.addAll(features);
            }
            if (!includeSuperclasses) {
                methodDataMap = new HashMap();
                this.getAllFeatures(methodDataMap, declarationSet, this);
                result.addAll(methodDataMap.values());
            }
            Collections.sort(result);
            return result;
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    private final void getAllFeatures(Map methodDataMap, Set declarationSet, Metafacade facade) {
        try {
            String declaration;
            MethodData method;
            String methodVisibility = "public";
            String indendation = "    * ";
            String fullyQualifiedName = facade.getFullyQualifiedName();
            Iterator iterator = facade.getProperties().iterator();
            while (iterator.hasNext()) {
                ModelElementFacade property = (ModelElementFacade)iterator.next();
                method = null;
                if (property instanceof AttributeFacade) {
                    AttributeFacade attribute = (AttributeFacade)property;
                    method = new MethodData(fullyQualifiedName, "public", false, attribute.getGetterSetterTypeName(), attribute.getGetterName(), attribute.getDocumentation("    * "));
                } else {
                    AssociationEndFacade association = (AssociationEndFacade)property;
                    method = new MethodData(fullyQualifiedName, "public", false, association.getGetterSetterTypeName(), association.getGetterName(), association.getDocumentation("    * "));
                }
                if (declarationSet.contains(declaration = method.buildMethodDeclaration(true))) continue;
                methodDataMap.put(method.buildCharacteristicKey(), method);
                declarationSet.add(declaration);
            }
            iterator = facade.getOperations().iterator();
            while (iterator.hasNext()) {
                OperationFacade operation = (OperationFacade)iterator.next();
                method = new UMLOperationData(fullyQualifiedName, operation);
                declaration = method.buildMethodDeclaration(true);
                if (declarationSet.contains(declaration)) continue;
                methodDataMap.put(method.buildCharacteristicKey(), method);
                declarationSet.add(declaration);
            }
        }
        catch (Throwable throwable) {
            this.logger.error((Object)throwable);
            throw new MetafacadeException(throwable);
        }
    }

    protected boolean handleIsRequiresInheritanceDelegatation() {
        boolean requiresInheritanceDelegation = false;
        GeneralizableElementFacade superMetafacade = this.getGeneralization();
        if (superMetafacade != null) {
            requiresInheritanceDelegation = !superMetafacade.getPackageName().equals(this.getPackageName()) || this.getGeneralizations().size() > 1;
        }
        return requiresInheritanceDelegation;
    }

    protected boolean handleIsConstructorRequiresMetaclassCast() {
        boolean requiresCast = false;
        Metafacade superMetafacade = (Metafacade)this.getGeneralization();
        if (superMetafacade != null) {
            requiresCast = superMetafacade.isMetaclassDirectDependency() && !this.isRequiresInheritanceDelegatation();
        }
        return requiresCast;
    }

    public Collection getGeneralizations() {
        ArrayList generalizations = new ArrayList(super.getGeneralizationLinks());
        Collections.sort(generalizations, new GeneralizationPrecedenceComparator());
        CollectionUtils.transform(generalizations, (Transformer)new Transformer(){

            public Object transform(Object object) {
                return ((GeneralizationFacade)object).getParent();
            }
        });
        CollectionUtils.filter(generalizations, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return object instanceof Metafacade;
            }
        });
        return generalizations;
    }

    protected int handleGetGeneralizationCount() {
        int count = 0;
        Collection generalizations = this.getGeneralizations();
        if (generalizations != null) {
            count = generalizations.size();
        }
        return count;
    }

    protected Collection handleGetAllParents() {
        LinkedHashSet allParents = new LinkedHashSet();
        Collection parents = this.getGeneralizations();
        allParents.addAll(parents);
        Iterator iterator = parents.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Metafacade)) continue;
            Metafacade metafacade = (Metafacade)object;
            allParents.addAll(metafacade.getAllParents());
        }
        return allParents;
    }

    static final class GeneralizationPrecedenceComparator
    implements Comparator {
        GeneralizationPrecedenceComparator() {
        }

        public int compare(Object objectA, Object objectB) {
            MetafacadeGeneralization a = (MetafacadeGeneralization)objectA;
            MetafacadeGeneralization b = (MetafacadeGeneralization)objectB;
            return a.getPrecedence().compareTo(b.getPrecedence());
        }
    }
}

