/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.meta;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.andromda.metafacades.uml.ConstraintFacade;
import org.andromda.metafacades.uml.ModelElementFacade;

public class MetaCartridgeUtils {
    public static Collection sortByFullyQualifiedName(Collection modelElements) {
        ArrayList sortedElements = null;
        if (modelElements != null) {
            sortedElements = new ArrayList(modelElements);
            Collections.sort(sortedElements, new FullyQualifiedNameComparator());
        }
        return sortedElements;
    }

    public static String getFullyQualifiedConstraintName(ConstraintFacade constraint) {
        StringBuffer name = new StringBuffer();
        if (constraint != null) {
            String contextElementName;
            ModelElementFacade contextElement = constraint.getContextElement();
            String string = contextElementName = contextElement != null ? contextElement.getFullyQualifiedName(true) : null;
            if (contextElementName != null && contextElementName.trim().length() > 0) {
                name.append(contextElementName.trim());
                name.append("::");
            }
            name.append(constraint.getName());
        }
        return name.toString();
    }

    static final class FullyQualifiedNameComparator
    implements Comparator {
        private final Collator collator = Collator.getInstance();

        FullyQualifiedNameComparator() {
            this.collator.setStrength(0);
        }

        public int compare(Object objectA, Object objectB) {
            ModelElementFacade a = (ModelElementFacade)objectA;
            ModelElementFacade b = (ModelElementFacade)objectB;
            return this.collator.compare(a.getFullyQualifiedName(), b.getFullyQualifiedName());
        }
    }
}

