/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.meta.metafacades;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.andromda.cartridges.meta.metafacades.ArgumentData;

public class MethodData
implements Comparable {
    private String metafacadeName;
    private String visibility;
    private boolean isAbstract;
    private String name;
    private String returnTypeName;
    private String documentation;
    private final ArrayList arguments = new ArrayList();
    private final ArrayList exceptions = new ArrayList();

    public MethodData(String metafacadeName, String visibility, boolean isAbstract, String returnTypeName, String name, String documentation) {
        this.metafacadeName = metafacadeName;
        this.visibility = visibility;
        this.isAbstract = isAbstract;
        this.name = name;
        this.returnTypeName = returnTypeName;
        this.documentation = documentation;
    }

    public void addArgument(ArgumentData argument) {
        this.arguments.add(argument);
    }

    public Collection getArguments() {
        return this.arguments;
    }

    public void addException(String typeName) {
        this.exceptions.add(typeName);
    }

    public Collection getExceptions() {
        return this.exceptions;
    }

    public String getMetafacadeName() {
        return this.metafacadeName;
    }

    public String getName() {
        return this.name;
    }

    public String getReturnTypeName() {
        return this.returnTypeName;
    }

    public String buildMethodDeclaration(boolean suppressAbstractDeclaration) {
        String declaration = this.visibility + " " + (this.isAbstract && !suppressAbstractDeclaration ? "abstract " : "") + (this.returnTypeName != null ? this.returnTypeName + " " : "") + this.name + "(";
        Iterator iterator = this.arguments.iterator();
        while (iterator.hasNext()) {
            ArgumentData argument = (ArgumentData)iterator.next();
            declaration = declaration + argument.getFullyQualifiedTypeName() + " " + argument.getName();
            if (!iterator.hasNext()) continue;
            declaration = declaration + ", ";
        }
        declaration = declaration + ")";
        if (this.exceptions.size() > 0) {
            declaration = declaration + " throws ";
            iterator = this.exceptions.iterator();
            while (iterator.hasNext()) {
                String exception = (String)iterator.next();
                declaration = declaration + exception;
                if (!iterator.hasNext()) continue;
                declaration = declaration + ", ";
            }
        }
        return declaration;
    }

    public String buildMethodCall() {
        String call = this.getName() + "(";
        Iterator iterator = this.arguments.iterator();
        while (iterator.hasNext()) {
            ArgumentData argument = (ArgumentData)iterator.next();
            call = call + argument.getName();
            if (!iterator.hasNext()) continue;
            call = call + ", ";
        }
        call = call + ")";
        return call;
    }

    public String buildCharacteristicKey() {
        String key = (this.returnTypeName != null ? this.returnTypeName + " " : "") + this.name + "(";
        Iterator iterator = this.arguments.iterator();
        while (iterator.hasNext()) {
            ArgumentData argument = (ArgumentData)iterator.next();
            key = key + argument.getFullyQualifiedTypeName();
            if (!iterator.hasNext()) continue;
            key = key + ",";
        }
        key = key + ")";
        return key;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public boolean isReturnTypePresent() {
        return this.returnTypeName != null && !this.returnTypeName.equals("void");
    }

    public int compareTo(Object object) {
        MethodData other = (MethodData)object;
        int result = this.getMetafacadeName().compareTo(other.getMetafacadeName());
        return result != 0 ? result : this.getName().compareTo(other.getName());
    }
}

