/**
 *   BugReporter Android library
 *
 *   @author Antonis Moustakos
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   as published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.amoustakos.bugreporter.utils;

public interface ErrorMessages {
    String BASE_NAME = "Bug Reporter: ";

    /*
     * Main
     */
    String CONTEXT_NULL = BASE_NAME + "Context cannot be null.";
    String NOT_INITIALIZED = BASE_NAME + "Not initialized.";
    String ALREADY_INITIALIZED = BASE_NAME + "Already initialized.";

    /*
     * Device Info
     */
    String DEV_INFO_COULD_NOT_GATHER = BASE_NAME + "Could not gather device information.";


    /*
     * Throwable bug
     */
    String THROWABLE_NULL = BASE_NAME + "The throwable provided was null";
}
