/**
 *   BugReporter Android library
 *
 *   @author Antonis Moustakos
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   as published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.amoustakos.bugreporter.reporters;

import android.support.annotation.NonNull;
import org.amoustakos.bugreporter.builders.BugBuilder;

/**
 * This is an abstract class that should be extended by all reporters.<br>
 * It holds the builder class that will be used to gather bug information:<br>
 * 1. {@link BugBuilder}<br>
 *<br>
 * One of the included extending classes can be included for bug reporting.<br>
 * See:
 */
public abstract class Reporter {
    @NonNull private BugBuilder builder;


    /*
     * Constructors
     */
    public Reporter(@NonNull BugBuilder builder) {this.builder = builder;}


    /*
     * Getters - Setters
     */
    @NonNull public BugBuilder getBuilder() {return builder;}
    public synchronized void setBuilder(@NonNull BugBuilder builder) {this.builder = builder;}
}
