/**
 *   BugReporter Android library
 *
 *   @author Antonis Moustakos
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   as published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.amoustakos.bugreporter.collectors.bugs;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

/**
 * Default {@link Bug} with the addition of a {@link StringBuilder} element<br>
 * to hold associated logs.<br>
 *
 * @see Bug
 */
public class BugWithLog extends Bug{
    @Nullable private StringBuilder log;


    /*
     * Constructors
     */
    /**
     * @see Bug#Bug()
     */
    public BugWithLog() {
        super();
        this.log = null;
    }
    /**
     * Default {@link Bug} constructor with log input.<br>
     * @see Bug#Bug()
     */
    public BugWithLog(@NonNull StringBuilder log) {
        super();
        this.log = log;
    }
    /**
     * Default {@link Bug} constructor with log and optional message input.<br>
     * @see Bug#Bug()
     */
    public BugWithLog(@Nullable String message, @Nullable StringBuilder log) {
        super();
        setMessage(message);
        this.log = log;
    }
    /**
     * Default {@link Bug} constructor with log, optional message and responsible class input.<br>
     * @see Bug#Bug(String, Class)
     */
    public BugWithLog(@Nullable String message, @Nullable StringBuilder log, @Nullable Class culprit) {
        super(message, culprit);
        this.log = log;
    }


    /*
     * Getters - Setters
     */
    /**
     * Gets the {@link StringBuilder} associated with this bug.
     */
    @Nullable public StringBuilder getLog() {return log;}
    /**
     * Sets the {@link StringBuilder} associated with this bug
     */
    public synchronized BugWithLog setLog(@Nullable StringBuilder log) {this.log = log; return this;}
}
