/**
 *   BugReporter Android library
 *
 *   @author Antonis Moustakos
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   as published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.amoustakos.bugreporter.utils;

import android.content.Context;
import android.util.Log;

import org.amoustakos.bugreporter.BugReporter;
import org.amoustakos.bugreporter.BuildConfig;

public class Utils {

    /*
     * Error checks
     */
    //Library init
    public static boolean isLibraryInitialized(String errorTag){
        if(!BugReporter.isInitialized())
            logE(errorTag, ErrorMessages.NOT_INITIALIZED);
        return BugReporter.isInitialized();
    }
    //Context
    public static boolean isContextNull(String errorTag, Context con){
        if(con == null)
            logE(errorTag, ErrorMessages.CONTEXT_NULL);
        return con == null;
    }




    /*
     * Logging
     */
    //Without throwable
    public static void logV(String tag, String message){log(Log.VERBOSE, tag, message, null);}
    public static void logD(String tag, String message){log(Log.DEBUG, tag, message, null);}
    public static void logI(String tag, String message){log(Log.INFO, tag, message, null);}
    public static void logW(String tag, String message){log(Log.WARN, tag, message, null);}
    public static void logE(String tag, String message){log(Log.ERROR, tag, message, null);}
    //with throwable
    public static void logV(String tag, String message, Throwable t){log(Log.VERBOSE, tag, message, t);}
    public static void logD(String tag, String message, Throwable t){log(Log.DEBUG, tag, message, t);}
    public static void logI(String tag, String message, Throwable t){log(Log.INFO, tag, message, t);}
    public static void logW(String tag, String message, Throwable t){log(Log.WARN, tag, message, t);}
    public static void logE(String tag, String message, Throwable t){log(Log.ERROR, tag, message, t);}
    public static void log(int logLevel, String tag, String message, Throwable t){
        if(!BuildConfig.DEBUG)
            return;
        if(tag == null)     tag = "";
        if(message == null) message = "";
        switch (logLevel){
            case Log.VERBOSE:
                if(t != null)
                    Log.v(tag, message, t);
                else
                    Log.v(tag, message);
                break;
            case Log.DEBUG:
                if(t != null)
                    Log.d(tag, message, t);
                else
                    Log.d(tag, message);
                break;
            case Log.INFO:
                if(t != null)
                    Log.i(tag, message, t);
                else
                    Log.i(tag, message);
                break;
            case Log.WARN:
                if(t != null)
                    Log.w(tag, message, t);
                else
                    Log.w(tag, message);
                break;
            case Log.ERROR:
                if(t != null)
                    Log.e(tag, message, t);
                else
                    Log.e(tag, message);
                break;
            default:
                break;
        }
    }
}
