/**
 *   BugReporter Android library
 *
 *   @author Antonis Moustakos
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   as published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.amoustakos.bugreporter.reporters;

import android.support.annotation.NonNull;

import org.amoustakos.bugreporter.builders.BugBuilder;
import org.amoustakos.bugreporter.collectors.application.ApplicationInfo;
import org.amoustakos.bugreporter.collectors.bugs.Bug;
import org.amoustakos.bugreporter.collectors.device.DeviceInfo;
import org.amoustakos.bugreporter.collectors.device.OSInfo;

public class TextReporter extends Reporter {


    /*
     * Constructors
     */
    public TextReporter(@NonNull BugBuilder builder) {
        super(builder);
    }


    public StringBuilder buildReport(){
        DeviceInfo devInfo = getBuilder().getDeviceInfo();
        OSInfo osInfo = getBuilder().getOSInfo();
        ApplicationInfo appInfo = getBuilder().getAppInfo();
        Bug bug = getBuilder().getBugInfo();

        StringBuilder report = new StringBuilder();
        //Device Info
        devInfo.buildTextReport(report);
        report.append("\n");
        report.append("\n");
        //OS Info
        osInfo.buildTextReport(report);
        report.append("\n");
        report.append("\n");
        //Application Info
        appInfo.buildTextReport(report);
        report.append("\n");
        report.append("\n");
        //Bug
        bug.buildTextReport(report);
        report.append("\n");
        report.append("\n");

        return report;
    }

    /*
     * Getters - Setters
     */
}
