/**
 *   BugReporter Android library
 *
 *   @author Antonis Moustakos
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   as published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package org.amoustakos.bugreporter;

import android.support.annotation.Nullable;
import org.amoustakos.bugreporter.utils.ErrorMessages;
import org.amoustakos.bugreporter.utils.Utils;


public class BugReporter {
    private static final String TAG = BugReporter.class.getSimpleName();
    private static BugReporter instance = null;
    private static boolean initialized = false;

    /*
     * Variables
     */
    //Optional
    private String appName;
    private String packageName;
    private String versionName;
    private Integer versionCode;


    /*
     * Constructors
     */
    private BugReporter(){}


    /*
     * Methods
     */
    public static synchronized void initialize(){
        if(!isInitialized())
            instance = new BugReporter()
                                .setAppName(null)
                                .setPackageName(null)
                                .setVersionName(null)
                                .setVersionCode(null);
        else
            Utils.logI(TAG, ErrorMessages.ALREADY_INITIALIZED);
    }
    public static synchronized void initialize( @Nullable String appName,
                                                @Nullable String packageName,
                                                @Nullable String versionName,
                                                @Nullable Integer versionCode){
        if(!isInitialized()){
            instance = new BugReporter()
                                .setAppName(appName)
                                .setPackageName(packageName)
                                .setVersionName(versionName)
                                .setVersionCode(versionCode);

            setInitialized(true);
        }
        else
            Utils.logI(TAG, ErrorMessages.ALREADY_INITIALIZED);
    }



    /*
     * Getters - Setters
     */
    public static boolean isInitialized() {return initialized;}
    public static synchronized void setInitialized(boolean initialized) {BugReporter.initialized = initialized;}
    public static synchronized BugReporter getInstance() {return instance;}

    public String getAppName() {return appName;}
    public synchronized BugReporter setAppName(@Nullable String appName) {this.appName = appName; return this;}
    public String getPackageName() {return packageName;}
    public synchronized BugReporter setPackageName(@Nullable String packageName) {this.packageName = packageName; return this;}
    public String getVersionName() {return versionName;}
    public synchronized BugReporter setVersionName(@Nullable String versionName) {this.versionName = versionName; return this;}
    public Integer getVersionCode() {return versionCode;}
    public synchronized BugReporter setVersionCode(@Nullable Integer versionCode) {this.versionCode = versionCode; return this;}
}
