/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.sns.client.configuration;

import org.ametiste.ifaces.protocol.Protocol;
import org.ametiste.sns.client.configuration.SnsProperties;
import org.ametiste.sns.client.drivers.ReportServiceDriver;
import org.ametiste.sns.client.drivers.SnsReportRESTfulServiceDriver;
import org.ametiste.sns.client.drivers.multithread.LimitableThreadPoolWrapperDriver;
import org.ametiste.sns.client.drivers.protocol.RestfulReportCreationProtocol;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={SnsProperties.class})
public class SnsDriverConfiguration {
    @Autowired
    private SnsProperties props;

    @Bean
    public ReportServiceDriver singleThreadDriver() {
        return new SnsReportRESTfulServiceDriver(this.props.getHost(), new RestTemplate(), (Protocol)new RestfulReportCreationProtocol(this.props.getRelativePath()));
    }

    @Bean(name={"driver"})
    @ConditionalOnMissingBean(name={"driver"})
    public ReportServiceDriver driver() {
        return new LimitableThreadPoolWrapperDriver(this.singleThreadDriver(), this.props.getThread().getName(), this.props.getNamespace(), this.props.getThread().getNumber(), this.props.getCapacity());
    }
}

