/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.sns.client.drivers.mock;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.ametiste.metrics.annotations.Countable;
import org.ametiste.sns.client.drivers.ReportMessage;
import org.ametiste.sns.client.drivers.ReportServiceDriver;
import org.ametiste.sns.client.drivers.mock.MockReportContainer;

public class MockReportServiceDriver
implements ReportServiceDriver {
    private List<ReportMessage> reports = new ArrayList<ReportMessage>();
    private boolean verifyStarted = false;

    @Countable(nameSuffixExpression="target.getSnsNamespace() + '.reports.count'")
    public void createNewReport(UUID reportId, Date date, String reportType, String reportSender, Serializable reportContent) {
        if (this.verifyStarted) {
            throw new IllegalArgumentException("Cannot register new reports after verify started");
        }
        this.reports.add(new ReportMessage(reportId, date, reportType, reportSender, reportContent));
    }

    public MockReportContainer verifyReport() {
        this.verifyStarted = true;
        return new MockReportContainer(this.reports);
    }

    public void reset() {
        this.reports.clear();
        this.verifyStarted = false;
    }

    public String getSnsNamespace() {
        return "sns";
    }
}

