/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.sns.client.drivers.mock;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.ametiste.sns.client.drivers.ReportMessage;

public class MockReportContainer {
    private List<ReportMessage> allReports;

    public MockReportContainer(List<ReportMessage> reports) {
        this.allReports = reports;
    }

    public MockReportContainer withType(String type) {
        this.allReports = this.allReports.stream().filter(reportMessage -> reportMessage.getType().equals(type)).collect(Collectors.toList());
        return this;
    }

    public MockReportContainer withRequestId(UUID id) {
        this.allReports = this.allReports.stream().filter(reportMessage -> reportMessage.getReportId().equals(id)).collect(Collectors.toList());
        return this;
    }

    public MockReportContainer withSender(String sender) {
        this.allReports = this.allReports.stream().filter(reportMessage -> reportMessage.getSender().equals(sender)).collect(Collectors.toList());
        return this;
    }

    public MockReportContainer withContentContains(String key) {
        ArrayList<ReportMessage> selectedReports = new ArrayList<ReportMessage>(this.allReports.size());
        this.allReports.stream().filter(reportMessage -> Map.class.isAssignableFrom(reportMessage.getContent().getClass())).forEach(reportMessage -> {
            try {
                Map map = (Map)((Object)reportMessage.getContent());
                if (map.containsKey(key)) {
                    selectedReports.add((ReportMessage)reportMessage);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.allReports = selectedReports;
        return this;
    }

    public MockReportContainer withContentContains(String key, Object value) {
        ArrayList<ReportMessage> selectedReports = new ArrayList<ReportMessage>(this.allReports.size());
        this.allReports.stream().filter(reportMessage -> Map.class.isAssignableFrom(reportMessage.getContent().getClass())).forEach(reportMessage -> {
            try {
                Map map = (Map)((Object)reportMessage.getContent());
                if (map.containsKey(key) && map.get(key).equals(value)) {
                    selectedReports.add((ReportMessage)reportMessage);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.allReports = selectedReports;
        return this;
    }

    public void wasRegistered(int times) {
        if (this.allReports.size() != times) {
            throw new AssertionError((Object)("Expected number of selected reports is " + times + " but was " + this.allReports.size()));
        }
    }

    public void wasRegistered() {
        if (this.allReports.size() == 0) {
            throw new AssertionError((Object)"Report was expected to be registered but wasnt ");
        }
    }

    public void wasntRegistered() {
        if (this.allReports.size() != 0) {
            throw new AssertionError((Object)("Report wasnt expected to be registered but was registered " + this.allReports.size() + " times"));
        }
    }
}

