/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.sns.data.content.templates;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.ametiste.sns.client.model.ReportContext;
import org.apache.commons.lang.exception.ExceptionUtils;

public class ThrowableContentTemplate {
    public static final String ERROR_CONTENT_TYPE = "com.dph.reports.content.contrib.ThrowableContent";
    private final Map<String, Serializable> map = new HashMap<String, Serializable>();
    private ReportContext context;
    private String stackTrace;
    private boolean isBuild;
    private Class<? extends Throwable> exceptionClass;

    private ThrowableContentTemplate() {
    }

    public static ThrowableContentTemplate createContent(Throwable error) {
        ThrowableContentTemplate template = new ThrowableContentTemplate();
        template.appendError(error);
        return template;
    }

    private void appendError(Throwable error) {
        this.stackTrace = ExceptionUtils.getStackTrace((Throwable)error);
        this.exceptionClass = error.getClass();
    }

    public ThrowableContentTemplate appendContext(ReportContext context) {
        this.context = context;
        return this;
    }

    public HashMap<String, Serializable> build() {
        if (this.isBuild) {
            throw new IllegalStateException("Report already built.");
        }
        if (this.context != null && !this.context.getContext().isEmpty()) {
            this.map.put("context", this.context.getContext());
        }
        this.map.put("stacktrace", (Serializable)((Object)this.stackTrace));
        this.map.put("errorClass", this.exceptionClass);
        try {
            HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>(this.map);
            return hashMap;
        }
        finally {
            this.isBuild = true;
        }
    }
}

