/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.sns.data.content.templates;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.LinkedMultiValueMap;

public class HttpRequestContentTemplate {
    public static final String CONTENT_TYPE = "com.dph.reports.content.contrib.HttpRequestContent";
    private final LinkedMultiValueMap<String, String> headers = new LinkedMultiValueMap();
    private String method;
    private String path;
    private String query;
    private boolean isBuild;
    private final HashMap<String, Serializable> content = new HashMap();

    public HttpRequestContentTemplate appendHeader(String name, String value) {
        this.headers.add((Object)name, (Object)value);
        return this;
    }

    public HttpRequestContentTemplate appendMethod(String method) {
        this.method = method;
        return this;
    }

    public HttpRequestContentTemplate appendPath(String path) {
        this.path = path;
        return this;
    }

    public HttpRequestContentTemplate appendQuery(String query) {
        this.query = query;
        return this;
    }

    public HttpRequestContentTemplate appendCustomField(String name, Serializable value) {
        this.content.put(name, value);
        return this;
    }

    public HashMap<String, Serializable> build() {
        if (this.isBuild) {
            throw new IllegalStateException("Report already built.");
        }
        if (this.method == null) {
            throw new IllegalStateException("Request should have method.");
        }
        if (this.path == null) {
            throw new IllegalStateException("Request should have path");
        }
        this.content.put("method", (Serializable)((Object)this.method));
        this.content.put("path", (Serializable)((Object)this.path));
        if (this.query != null && !this.query.isEmpty()) {
            this.content.put("query", (Serializable)((Object)this.query));
        }
        if (this.headers.size() > 0) {
            this.content.put("headers", (Serializable)this.headers);
        }
        try {
            HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>(this.content);
            return hashMap;
        }
        finally {
            this.isBuild = true;
        }
    }

    public static HttpRequestContentTemplate createTemplate() {
        return new HttpRequestContentTemplate();
    }

    public static HttpRequestContentTemplate createTemplateFromRequest(HttpServletRequest request) {
        HttpRequestContentTemplate contentTemplate = HttpRequestContentTemplate.createTemplate().appendMethod(request.getMethod()).appendPath(request.getRequestURI()).appendQuery(request.getQueryString());
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            contentTemplate.appendHeader(headerName, request.getHeader(headerName));
        }
        return contentTemplate;
    }

    public static HashMap<String, Serializable> createContentFromRequest(HttpServletRequest request) {
        return HttpRequestContentTemplate.createTemplateFromRequest(request).build();
    }
}

