/*
 * Decompiled with CFR 0.152.
 */
package org.ametiste.sns.data.content.templates;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.ametiste.sns.client.model.Report;
import org.ametiste.sns.client.model.ReportContext;

public class AggregatingContentTemplate {
    public static final String AGGREGATING_CONTENT_TYPE = "com.dph.reports.content.contrib.AggregatingContent";
    private final Map<String, Serializable> map = new HashMap<String, Serializable>();
    private ReportContext context;
    private boolean isBuild;
    private Report report;
    private int counter;

    private AggregatingContentTemplate() {
    }

    public static AggregatingContentTemplate createContent(Report originalReport) {
        AggregatingContentTemplate template = new AggregatingContentTemplate();
        template.appendReport(originalReport);
        return template;
    }

    private void appendReport(Report report) {
        this.report = report;
    }

    public AggregatingContentTemplate appendContext(ReportContext context) {
        this.context = context;
        return this;
    }

    public AggregatingContentTemplate appendCounter(int counter) {
        this.counter = counter;
        return this;
    }

    public HashMap<String, Serializable> build() {
        if (this.isBuild) {
            throw new IllegalStateException("Report already built.");
        }
        if (this.context != null && !this.context.getContext().isEmpty()) {
            this.map.put("context", this.context.getContext());
        }
        this.map.put("agregatedReport", this.report);
        this.map.put("reportsAmount", Integer.valueOf(this.counter));
        try {
            HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>(this.map);
            return hashMap;
        }
        finally {
            this.isBuild = true;
        }
    }
}

